/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.sound;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.sound.RadioStation;

public class RadioManager {
    private static final File musicDir;
    private static final File radioStationsFile;
    private static final Map<Integer, RadioStation> localSourcesMap;
    private static final Map<String, RadioStation> internetSourcesMap;

    public static RadioStation getLocalStation(int index, boolean randomOrder) {
        Integer mapKey = index;
        if (!localSourcesMap.containsKey(mapKey)) {
            localSourcesMap.put(mapKey, new RadioStation(index, randomOrder));
        }
        return localSourcesMap.get(mapKey);
    }

    public static RadioStation getInternetStation(String url) {
        if (!internetSourcesMap.containsKey(url)) {
            internetSourcesMap.put(url, new RadioStation(url));
        }
        return internetSourcesMap.get(url);
    }

    public static List<File> parseLocalDirectory(int index, boolean randomOrder) {
        ArrayList<File> musicDirectories = new ArrayList<File>();
        ArrayList<File> musicFiles = new ArrayList<File>();
        for (File file : musicDir.listFiles()) {
            if (!file.isDirectory()) continue;
            musicDirectories.add(file);
        }
        Collections.sort(musicDirectories);
        if (musicDirectories.size() > index) {
            for (File musicFile : ((File)musicDirectories.get(index)).listFiles()) {
                if (musicFile.isDirectory()) continue;
                musicFiles.add(musicFile);
            }
            if (randomOrder) {
                Collections.shuffle(musicFiles);
            } else {
                Collections.sort(musicFiles);
            }
        }
        return musicFiles;
    }

    public static String getLocalStationURL(int index) {
        try {
            ArrayList<String> stations = new ArrayList<String>();
            BufferedReader radioStationFileReader = new BufferedReader(new FileReader(radioStationsFile));
            while (radioStationFileReader.ready()) {
                stations.add(radioStationFileReader.readLine());
            }
            radioStationFileReader.close();
            if (stations.size() > --index) {
                return (String)stations.get(index);
            }
            return "";
        }
        catch (IOException e) {
            InterfaceManager.coreInterface.logError("Unable to parse radio_stations.txt file.  Is it in use?");
            InterfaceManager.coreInterface.logError(e.getMessage());
            return "";
        }
    }

    public static void setLocalStationURL(String stationURL, int index) {
        try {
            ArrayList<String> stations = new ArrayList<String>();
            BufferedReader radioStationFileReader = new BufferedReader(new FileReader(radioStationsFile));
            while (radioStationFileReader.ready()) {
                stations.add(radioStationFileReader.readLine());
            }
            radioStationFileReader.close();
            if (stations.size() < 6) {
                for (int i = stations.size(); i < 6; ++i) {
                    stations.add("");
                }
            }
            stations.set(index, stationURL);
            BufferedWriter radioStationFileWriter = new BufferedWriter(new FileWriter(radioStationsFile));
            for (String stationToWrite : stations) {
                radioStationFileWriter.write(stationToWrite + "\n");
            }
            radioStationFileWriter.close();
        }
        catch (IOException e) {
            InterfaceManager.coreInterface.logError("Unable to save radio_stations.txt file.  Is it in use?");
            InterfaceManager.coreInterface.logError(e.getMessage());
        }
    }

    static {
        localSourcesMap = new HashMap<Integer, RadioStation>();
        internetSourcesMap = new HashMap<String, RadioStation>();
        musicDir = new File(InterfaceManager.gameDirectory, "mts_music");
        musicDir.mkdir();
        radioStationsFile = new File(musicDir.getAbsolutePath() + File.separator + "radio_stations.txt");
        if (!radioStationsFile.exists()) {
            try {
                radioStationsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum RadioSources {
        LOCAL,
        SERVER,
        INTERNET;

    }
}

