/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketPlayer;
import minecrafttransportsimulator.systems.LanguageSystem;

public class PacketPlayerChatMessage
extends APacketPlayer {
    private final LanguageSystem.LanguageEntry language;
    private final String[] message;

    public PacketPlayerChatMessage(IWrapperPlayer player, LanguageSystem.LanguageEntry language, Object ... args) {
        super(player);
        this.language = language;
        this.message = new String[args.length];
        for (int i = 0; i < args.length; i = (int)((byte)(i + 1))) {
            this.message[i] = args[i].toString();
        }
    }

    public PacketPlayerChatMessage(ByteBuf buf) {
        super(buf);
        this.language = LanguageSystem.coreLanguageEntires.get(PacketPlayerChatMessage.readStringFromBuffer(buf));
        this.message = new String[buf.readByte()];
        for (int i = 0; i < this.message.length; i = (int)((byte)(i + 1))) {
            this.message[i] = PacketPlayerChatMessage.readStringFromBuffer(buf);
        }
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPlayerChatMessage.writeStringToBuffer(this.language.key, buf);
        buf.writeByte(this.message.length);
        for (int i = 0; i < this.message.length; i = (int)((byte)(i + 1))) {
            PacketPlayerChatMessage.writeStringToBuffer(this.message[i], buf);
        }
    }

    @Override
    public void handle(AWrapperWorld world, IWrapperPlayer player) {
        player.displayChatMessage(this.language, this.message);
    }
}

