/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntity;

public class PacketPartChange_Remove
extends APacketEntity<AEntityF_Multipart<?>> {
    private final UUID partUUID;
    private final boolean doFinalTick;

    public PacketPartChange_Remove(APart partRemoved, boolean doFinalTick) {
        super(partRemoved.entityOn);
        this.partUUID = partRemoved.uniqueUUID;
        this.doFinalTick = doFinalTick;
    }

    public PacketPartChange_Remove(ByteBuf buf) {
        super(buf);
        this.partUUID = PacketPartChange_Remove.readUUIDFromBuffer(buf);
        this.doFinalTick = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketPartChange_Remove.writeUUIDToBuffer(this.partUUID, buf);
        buf.writeBoolean(this.doFinalTick);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityF_Multipart<?> entity) {
        APart part = (APart)world.getEntity(this.partUUID);
        if (part != null) {
            part.entityOn.removePart(part, this.doFinalTick, false);
        }
        return false;
    }
}

