/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.packets.components.APacketEntityInteractHitbox;

public class PacketEntityBulletHitEntity
extends APacketEntityInteractHitbox {
    private final UUID gunID;
    private final double amount;

    public PacketEntityBulletHitEntity(PartGun gun, AEntityE_Interactable<?> entity, Damage damage) {
        super(entity, damage.box);
        this.gunID = gun.uniqueUUID;
        this.amount = damage.amount;
    }

    public PacketEntityBulletHitEntity(ByteBuf buf) {
        super(buf);
        this.gunID = PacketEntityBulletHitEntity.readUUIDFromBuffer(buf);
        this.amount = buf.readDouble();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityBulletHitEntity.writeUUIDToBuffer(this.gunID, buf);
        buf.writeDouble(this.amount);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityE_Interactable<?> entity, BoundingBox hitBox) {
        EntityBullet.performEntityHitLogic(entity, new Damage(world.getBulletGun(this.gunID), hitBox, this.amount));
        return false;
    }
}

