/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.components;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketBase;

public abstract class APacketPlayer
extends APacketBase {
    private final UUID playerID;

    public APacketPlayer(IWrapperPlayer player) {
        super(null);
        this.playerID = player.getID();
    }

    public APacketPlayer(ByteBuf buf) {
        super(buf);
        this.playerID = APacketPlayer.readUUIDFromBuffer(buf);
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        APacketPlayer.writeUUIDToBuffer(this.playerID, buf);
    }

    @Override
    public void handle(AWrapperWorld world) {
        IWrapperPlayer player = (IWrapperPlayer)world.getExternalEntity(this.playerID);
        if (player != null) {
            this.handle(world, player);
        }
    }

    protected abstract void handle(AWrapperWorld var1, IWrapperPlayer var2);
}

