/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.jsondefs;

import java.util.List;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.packloading.JSONParser;

@JSONParser.JSONDescription(value="While allowing users to craft vehicles is great, it can get a bit un-realistic to make a truck out of stacks of iron ingots and glass.  To help with this, MTS allows you to make custom items.  These items are loaded via JSON like all other vehicle bits, but rather than use an OBJ model they use the normal Minecraft item JSON format.  This allows you to take any JSON outputted from any modeling software (such as BlockBench) and plop it, along with a small file in the jsondefs section, into your pack for crafting use!  Items just have a general section per the default.  That's it.  If you want to add functionality to your items, you can do so by giving the appropriate type parameter.")
public class JSONItem
extends AJSONItem {
    @JSONParser.JSONDescription(value="Properties for all items..")
    public JSONItemGeneric item;
    @JSONParser.JSONRequired(dependentField="type", dependentValues={"booklet"}, subField="item")
    @JSONParser.JSONDescription(value="Booklet-specific item section.")
    public JSONBooklet booklet;
    @JSONParser.JSONRequired(dependentField="type", dependentValues={"food"}, subField="item")
    @JSONParser.JSONDescription(value="Food-specific item section.")
    public JSONFood food;
    @JSONParser.JSONRequired(dependentField="type", dependentValues={"weapon"}, subField="item")
    @JSONParser.JSONDescription(value="Weapon-specific item section.")
    public JSONWeapon weapon;
    @JSONParser.JSONRequired(dependentField="type", dependentValues={"repair"}, subField="item")
    @JSONParser.JSONDescription(value="Repair-specific item section.")
    public JSONRepair repair;

    public static enum ItemComponentType {
        NONE,
        BOOKLET,
        FOOD,
        WEAPON,
        SCANNER,
        WRENCH,
        SCREWDRIVER,
        PAINT_GUN,
        KEY,
        TICKET,
        FUEL_HOSE,
        JUMPER_CABLES,
        JUMPER_PACK,
        REPAIR_PACK,
        Y2K_BUTTON;

    }

    public static class JSONRepair {
        @JSONParser.JSONDescription(value="Normally, repair pack cannot repair totaled vehicles.  This allows them to do so.")
        public boolean canRepairTotaled;
        @JSONParser.JSONDescription(value="How much health repair pack restores.")
        public int amount;
    }

    public static class JSONWeapon {
        @JSONParser.JSONDescription(value="How much damage this weapon will inflict when it hits an entity.")
        public double attackDamage;
        @JSONParser.JSONDescription(value="How long, in ticks, between each strike of this weapon.")
        public double attackCooldown;
    }

    public static class JSONFood {
        @JSONParser.JSONDescription(value="The animation to play while consuming this item.  If true, the drinking animation is played.  If false, the eating animation is played.")
        public boolean isDrink;
        @JSONParser.JSONDescription(value="How long, in ticks, it takes to eat this food item.")
        public int timeToEat;
        @JSONParser.JSONDescription(value="How much hunger this food item fills.  Must be a whole number.")
        public int hungerAmount;
        @JSONParser.JSONDescription(value="How much saturation this food has.  May be a decimal.")
        public float saturationAmount;
        @JSONParser.JSONDescription(value="A optional list of effects that this food item provides.")
        public List<JSONPotionEffect> effects;
    }

    public static class JSONBooklet {
        @JSONParser.JSONDescription(value="How wide of a texture, in px, this booklet uses.  Used for ALL pages")
        public int textureWidth;
        @JSONParser.JSONDescription(value="How high of a texture, in px, this booklet uses.  Used for ALL pages")
        public int textureHeight;
        @JSONParser.JSONDescription(value="If present and true, the Table of Contents will not be created.")
        public boolean disableTOC;
        @JSONParser.JSONDescription(value="The name of the texture for the cover.  Should be prefixed by your modID and MUST be a power of 2.")
        public String coverTexture;
        @JSONParser.JSONDescription(value="A list of Text objects that make up the text for the title.")
        public List<JSONText> titleText;
        @JSONParser.JSONDescription(value="A list of Page objects that make up the pages of this booklet.")
        public List<BookletPage> pages;

        public static class BookletPage {
            @JSONParser.JSONDescription(value="The name of the texture for this page.  Each page may use a different texture, if desired.\nHowever, all textures MUST be the same resolution as defined by textureWidth and textureHeight.")
            public String pageTexture;
            @JSONParser.JSONDescription(value="The title for this page that will be used to make the Table of Contents.  May be omitted if the Table of Contents is disabled.")
            public String title;
            @JSONParser.JSONDescription(value="An list of text objects that make up the text for the page. These follow the same format as textObjects.\nThe only difference between these and vehicles is the z-coord should always be 0, and the defaultText parameter is what will be rendered in the booklet.")
            public List<JSONText> pageText;
        }
    }

    public static class JSONItemGeneric {
        @JSONParser.JSONDescription(value="The functionality to give this item.")
        public ItemComponentType type;
    }
}

