/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentInstrument;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.AJSONInteractableEntity;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONConnectionGroup;
import minecrafttransportsimulator.jsondefs.JSONInstrumentDefinition;
import minecrafttransportsimulator.jsondefs.JSONPanel;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableIncrement;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableSet;
import minecrafttransportsimulator.packets.instances.PacketEntityVariableToggle;
import minecrafttransportsimulator.packets.instances.PacketVehicleBeaconChange;
import minecrafttransportsimulator.packloading.PackParser;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class GUIPanel
extends AGUIBase {
    private final EntityVehicleF_Physics vehicle;
    private final JSONPanel definition;
    private final List<SwitchEntry> trailerSwitchDefs = new ArrayList<SwitchEntry>();
    private final Map<String, List<ComputedVariable>> customVariables = new LinkedHashMap<String, List<ComputedVariable>>();
    private final List<GUIPanelButton> componentButtons = new ArrayList<GUIPanelButton>();
    private final List<GUIComponentLabel> labels = new ArrayList<GUIComponentLabel>();
    private GUIComponentTextBox beaconBox;

    public GUIPanel(EntityVehicleF_Physics vehicle) {
        this.vehicle = vehicle;
        this.definition = GUIPanel.getDefinitionFor(vehicle);
    }

    public static JSONPanel getDefinitionFor(EntityVehicleF_Physics vehicle) {
        JSONPanel panel = null;
        try {
            String packID = ((JSONVehicle)vehicle.definition).motorized.panel.substring(0, ((JSONVehicle)vehicle.definition).motorized.panel.indexOf(58));
            String systemName = ((JSONVehicle)vehicle.definition).motorized.panel.substring(packID.length() + 1);
            panel = PackParser.getPackPanel(packID, systemName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (panel != null) {
            return panel;
        }
        InterfaceManager.clientInterface.getClientPlayer().displayChatMessage(LanguageSystem.SYSTEM_DEBUG, "Could not display the requested panel " + ((JSONVehicle)vehicle.definition).motorized.panel + ". Report this to the pack author!  Default panel will be used.");
        if (((JSONVehicle)vehicle.definition).motorized.isAircraft) {
            return PackParser.getPackPanel(InterfaceManager.coreModID, "default_plane");
        }
        return PackParser.getPackPanel(InterfaceManager.coreModID, "default_car");
    }

    private void setupTowingButtons(AEntityG_Towable<?> entity) {
        if (((AJSONPartProvider)entity.definition).connectionGroups != null) {
            for (JSONConnectionGroup connectionGroup : ((AJSONPartProvider)entity.definition).connectionGroups) {
                if (!connectionGroup.canInitiateConnections) continue;
                this.trailerSwitchDefs.add(new SwitchEntry(entity, connectionGroup));
            }
            for (TowingConnection connection : entity.towingConnections) {
                if (!connection.hookupConnectionGroup.canInitiateSubConnections) continue;
                this.setupTowingButtons(connection.towedVehicle);
            }
        }
        for (APart part : entity.allParts) {
            if (((JSONPart)part.definition).connectionGroups == null) continue;
            for (JSONConnectionGroup connectionGroup : ((JSONPart)part.definition).connectionGroups) {
                if (!connectionGroup.canInitiateConnections) continue;
                this.trailerSwitchDefs.add(new SwitchEntry(part, connectionGroup));
            }
        }
    }

    public void handleConnectionChange(TowingConnection connection) {
        boolean recreatePanel = false;
        for (SwitchEntry entry : this.trailerSwitchDefs) {
            if (!entry.vehicleOn.equals(connection.towingVehicle) && !entry.vehicleOn.equals(connection.towedVehicle)) continue;
            recreatePanel = true;
            break;
        }
        if (recreatePanel) {
            this.setupComponents();
        }
    }

    @Override
    public final void setupComponents() {
        super.setupComponents();
        this.trailerSwitchDefs.clear();
        this.setupTowingButtons(this.vehicle);
        this.customVariables.clear();
        if (((JSONVehicle)this.vehicle.definition).rendering.customVariables != null) {
            for (String variable : ((JSONVehicle)this.vehicle.definition).rendering.customVariables) {
                this.customVariables.computeIfAbsent(variable, key -> new ArrayList()).add(this.vehicle.getOrCreateVariable(variable));
            }
        }
        for (APart part : this.vehicle.allParts) {
            if (((JSONPart)part.definition).rendering == null || ((JSONPart)part.definition).rendering.customVariables == null) continue;
            for (String variable : ((JSONPart)part.definition).rendering.customVariables) {
                this.customVariables.computeIfAbsent(variable, key -> new ArrayList()).add(part.getOrCreateVariable(variable));
            }
        }
        this.componentButtons.clear();
        this.labels.clear();
        boolean populatedSingleEngineControl = false;
        boolean populatedSingleEngineMag = false;
        boolean populatedSingleEngineStarter = false;
        int engineControlIndex = 0;
        int engineMagIndex = 0;
        int engineStarterIndex = 0;
        int trailerIndex = 0;
        int customVariableIndex = 0;
        for (final JSONPanel.JSONPanelComponent panelComponent : this.definition.panel.components) {
            GUIComponentCutout newComponent = null;
            String text = null;
            if (panelComponent.specialComponent == null) {
                newComponent = new GUIPanelButton((AGUIBase)this, panelComponent){

                    @Override
                    public void onClicked(boolean leftSide) {
                        if (panelComponent.clickAction != null) {
                            GUIPanel.this.handleClickAction(panelComponent.clickAction);
                        }
                        if (panelComponent.clickActionLeft != null && leftSide) {
                            GUIPanel.this.handleClickAction(panelComponent.clickActionLeft);
                        }
                        if (panelComponent.clickActionRight != null && !leftSide) {
                            GUIPanel.this.handleClickAction(panelComponent.clickActionRight);
                        }
                    }
                };
                text = panelComponent.text;
            } else {
                final ArrayList<ComputedVariable> buttonVariables = new ArrayList<ComputedVariable>();
                switch (panelComponent.specialComponent) {
                    case CAR_LIGHT: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasRunningLights && !((JSONVehicle)this.vehicle.definition).motorized.hasHeadlights) break;
                        newComponent = new GUIPanelButton(this, panelComponent){

                            @Override
                            public void onClicked(boolean leftSide) {
                                if (leftSide) {
                                    if (((GUIPanel)GUIPanel.this).vehicle.headLightVar.isActive) {
                                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(((GUIPanel)GUIPanel.this).vehicle.headLightVar));
                                    } else if (((GUIPanel)GUIPanel.this).vehicle.runningLightVar.isActive) {
                                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(((GUIPanel)GUIPanel.this).vehicle.runningLightVar));
                                    }
                                } else if (((JSONVehicle)((GUIPanel)GUIPanel.this).vehicle.definition).motorized.hasRunningLights && !((GUIPanel)GUIPanel.this).vehicle.runningLightVar.isActive) {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(((GUIPanel)GUIPanel.this).vehicle.runningLightVar));
                                } else if (((JSONVehicle)((GUIPanel)GUIPanel.this).vehicle.definition).motorized.hasHeadlights && !((GUIPanel)GUIPanel.this).vehicle.headLightVar.isActive) {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(((GUIPanel)GUIPanel.this).vehicle.headLightVar));
                                }
                            }

                            @Override
                            public int getState() {
                                return ((GUIPanel)GUIPanel.this).vehicle.headLightVar.isActive ? 2 : (((GUIPanel)GUIPanel.this).vehicle.runningLightVar.isActive ? 1 : 0);
                            }
                        };
                        text = "LIGHTS";
                        break;
                    }
                    case TURN_SIGNAL: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasTurnSignals) break;
                        newComponent = new GUIPanelButton(this, panelComponent){

                            @Override
                            public void onClicked(boolean leftSide) {
                                if (leftSide) {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(((GUIPanel)GUIPanel.this).vehicle.leftTurnLightVar));
                                } else {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(((GUIPanel)GUIPanel.this).vehicle.rightTurnLightVar));
                                }
                            }

                            @Override
                            public int getState() {
                                if (GUIPanel.inClockPeriod(20, 10)) {
                                    int returnValue = 0;
                                    if (((GUIPanel)GUIPanel.this).vehicle.leftTurnLightVar.isActive) {
                                        ++returnValue;
                                    }
                                    if (((GUIPanel)GUIPanel.this).vehicle.rightTurnLightVar.isActive) {
                                        returnValue += 2;
                                    }
                                    return returnValue;
                                }
                                return 0;
                            }
                        };
                        text = "TURNSGNL";
                        break;
                    }
                    case NAVIGATION_LIGHT: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasNavLights) break;
                        buttonVariables.add(this.vehicle.navigationLightVar);
                        text = "NAV";
                        break;
                    }
                    case STROBE_LIGHT: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasStrobeLights) break;
                        buttonVariables.add(this.vehicle.strobeLightVar);
                        text = "STROBE";
                        break;
                    }
                    case TAXI_LIGHT: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasTaxiLights) break;
                        buttonVariables.add(this.vehicle.taxiLightVar);
                        text = "TAXI";
                        break;
                    }
                    case LANDING_LIGHT: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasLandingLights) break;
                        buttonVariables.add(this.vehicle.landingLightVar);
                        text = "LAND";
                        break;
                    }
                    case ENGINE_CONTROL: {
                        PartEngine engine;
                        if (this.vehicle.engines.isEmpty()) break;
                        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
                            if (populatedSingleEngineControl) break;
                            newComponent = new GUIPanelEngineButton(this, panelComponent, null);
                            text = "ENGINE";
                            populatedSingleEngineControl = true;
                            break;
                        }
                        if ((engine = this.getEngineBySwitchIndex(engineControlIndex++)) == null) break;
                        newComponent = new GUIPanelEngineButton(this, panelComponent, engine);
                        text = "ENGINE";
                        break;
                    }
                    case ENGINE_ON: {
                        PartEngine engine;
                        if (this.vehicle.engines.isEmpty()) break;
                        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
                            if (populatedSingleEngineMag) break;
                            newComponent = new GUIPanelEngineButton(this, panelComponent, null);
                            text = "MAG";
                            populatedSingleEngineMag = true;
                            break;
                        }
                        if ((engine = this.getEngineBySwitchIndex(engineMagIndex++)) == null) break;
                        newComponent = new GUIPanelEngineButton(this, panelComponent, engine);
                        text = "MAG";
                        break;
                    }
                    case ENGINE_START: {
                        PartEngine engine;
                        if (this.vehicle.engines.isEmpty()) break;
                        if (((JSONVehicle)this.vehicle.definition).motorized.hasSingleEngineControl) {
                            if (populatedSingleEngineStarter) break;
                            newComponent = new GUIPanelEngineButton(this, panelComponent, null);
                            text = "START";
                            populatedSingleEngineStarter = true;
                            break;
                        }
                        if ((engine = this.getEngineBySwitchIndex(engineStarterIndex++)) == null) break;
                        newComponent = new GUIPanelEngineButton(this, panelComponent, engine);
                        text = "START";
                        break;
                    }
                    case TRAILER: {
                        if (this.trailerSwitchDefs.size() <= trailerIndex) break;
                        final SwitchEntry switchDef = this.trailerSwitchDefs.get(trailerIndex++);
                        text = switchDef.connectionGroup.groupName;
                        newComponent = new GUIPanelButton((AGUIBase)this, panelComponent){

                            @Override
                            public void onClicked(boolean leftSide) {
                                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(switchDef.connectionDefiner.towingConnectionVar, switchDef.connectionGroupIndex + 1));
                            }

                            @Override
                            public int getState() {
                                return switchDef.isConnected() ? 1 : 0;
                            }
                        };
                        break;
                    }
                    case AUTOPILOT: {
                        newComponent = new GUIPanelButton(this, panelComponent){

                            @Override
                            public void onClicked(boolean leftSide) {
                                if (((GUIPanel)GUIPanel.this).vehicle.autopilotValueVar.isActive) {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(((GUIPanel)GUIPanel.this).vehicle.autopilotValueVar, 0.0));
                                } else if (((JSONVehicle)((GUIPanel)GUIPanel.this).vehicle.definition).motorized.isAircraft) {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(((GUIPanel)GUIPanel.this).vehicle.autopilotValueVar, ((GUIPanel)GUIPanel.this).vehicle.position.y));
                                } else {
                                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(((GUIPanel)GUIPanel.this).vehicle.autopilotValueVar, ((GUIPanel)GUIPanel.this).vehicle.indicatedSpeed));
                                }
                            }

                            @Override
                            public int getState() {
                                return ((GUIPanel)GUIPanel.this).vehicle.autopilotValueVar.isActive ? 1 : 0;
                            }
                        };
                        text = ((JSONVehicle)this.vehicle.definition).motorized.isAircraft ? "AUTO" : "CRUISE";
                        break;
                    }
                    case CUSTOM_VARIABLE: {
                        if (this.customVariables.size() <= customVariableIndex) break;
                        int i = 0;
                        Iterator<Map.Entry<String, List<ComputedVariable>>> iterator = this.customVariables.entrySet().iterator();
                        while (i++ < customVariableIndex) {
                            iterator.next();
                        }
                        Map.Entry<String, List<ComputedVariable>> entry = iterator.next();
                        buttonVariables.addAll((Collection)entry.getValue());
                        text = entry.getKey();
                        ++customVariableIndex;
                        break;
                    }
                    case BEACON_BOX: {
                        if (!((JSONVehicle)this.vehicle.definition).motorized.hasRadioNav && !((Boolean)ConfigSystem.settings.general.allPlanesWithNav.value).booleanValue()) break;
                        this.beaconBox = new GUIComponentTextBox(this, this.guiLeft + (int)panelComponent.pos.x, this.guiTop + (int)panelComponent.pos.y, panelComponent.width, panelComponent.height, this.vehicle.selectedBeaconName, ColorRGB.WHITE, 5, (int)panelComponent.textureStart.x, (int)panelComponent.textureStart.y, panelComponent.width, panelComponent.height){

                            @Override
                            public void handleKeyTyped(char typedChar, int typedCode, GUIComponentTextBox.TextBoxControlKey control) {
                                super.handleKeyTyped(typedChar, typedCode, control);
                                InterfaceManager.packetInterface.sendToServer(new PacketVehicleBeaconChange(GUIPanel.this.vehicle, this.getText()));
                            }
                        };
                        this.addComponent(this.beaconBox);
                        newComponent = this.beaconBox;
                        text = "BEACON";
                        break;
                    }
                    case ROLL_TRIM: {
                        newComponent = new GUIPanelTrimButton(this, panelComponent, this.vehicle.aileronTrimVar, -0.1, 10.0);
                        text = "ROLL TRIM";
                        break;
                    }
                    case PITCH_TRIM: {
                        newComponent = new GUIPanelTrimButton(this, panelComponent, this.vehicle.elevatorTrimVar, 0.1, 10.0);
                        text = "PITCH TRIM";
                        break;
                    }
                    case YAW_TRIM: {
                        newComponent = new GUIPanelTrimButton(this, panelComponent, this.vehicle.rudderTrimVar, -0.1, 10.0);
                        text = "YAW TRIM";
                    }
                }
                if (!buttonVariables.isEmpty()) {
                    newComponent = new GUIPanelButton((AGUIBase)this, panelComponent){

                        @Override
                        public void onClicked(boolean leftSide) {
                            buttonVariables.forEach(variable -> InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle((ComputedVariable)variable)));
                        }

                        @Override
                        public int getState() {
                            return ((ComputedVariable)buttonVariables.get((int)0)).isActive ? 1 : 0;
                        }
                    };
                }
            }
            if (newComponent == null) continue;
            if (panelComponent.text != null) {
                text = panelComponent.text;
            }
            if (text == null) continue;
            GUIComponentLabel label = new GUIComponentLabel(newComponent.constructedX + newComponent.width / 2, newComponent.constructedY + newComponent.height + 1, ColorRGB.WHITE, text, RenderText.TextAlignment.CENTERED, 0.75f).setComponent(newComponent);
            this.labels.add(label);
            this.addComponent(label);
        }
        this.trailerSwitchDefs.clear();
        this.setupTowingButtons(this.vehicle);
        for (int i = 0; i < this.vehicle.instruments.size(); ++i) {
            if (this.vehicle.instruments.get(i) == null || !((JSONInstrumentDefinition)((JSONVehicle)this.vehicle.definition).instruments.get((int)i)).placeOnPanel) continue;
            this.addComponent(new GUIComponentInstrument(this.guiLeft, this.guiTop, this.vehicle, i));
        }
        for (APart part : this.vehicle.allParts) {
            for (int i = 0; i < part.instruments.size(); ++i) {
                if (part.instruments.get(i) == null || !((JSONInstrumentDefinition)((JSONPart)part.definition).instruments.get((int)i)).placeOnPanel) continue;
                this.addComponent(new GUIComponentInstrument(this.guiLeft, this.guiTop, part, i));
            }
        }
    }

    @Override
    public void setStates() {
        for (GUIPanelButton button : this.componentButtons) {
            List<List<String>> visibilityVariables = button.component.visibilityVariables;
            if (visibilityVariables != null) {
                button.visible = this.vehicle.isVariableListTrue(visibilityVariables);
            }
            if (!button.visible) continue;
            button.textureYOffset = (int)button.component.textureStart.y + button.component.height * button.getState();
        }
        if (this.beaconBox != null) {
            this.beaconBox.fontColor = this.vehicle.selectedBeacon != null ? ColorRGB.GREEN : ColorRGB.RED;
        }
        for (GUIComponentLabel label : this.labels) {
            ColorRGB color = this.getGUILightMode() == AGUIBase.GUILightingMode.LIT ? this.definition.panel.litTextColor : this.definition.panel.textColor;
            label.color = color != null ? color : ColorRGB.WHITE;
        }
    }

    @Override
    protected AGUIBase.GUILightingMode getGUILightMode() {
        return this.vehicle.renderTextLit() ? AGUIBase.GUILightingMode.LIT : AGUIBase.GUILightingMode.DARK;
    }

    @Override
    protected EntityVehicleF_Physics getGUILightSource() {
        return this.vehicle;
    }

    @Override
    protected boolean canStayOpen() {
        return super.canStayOpen() && this.vehicle.isValid;
    }

    @Override
    public int getWidth() {
        return this.definition.panel.backgroundWidth;
    }

    @Override
    public int getHeight() {
        return this.definition.panel.backgroundHeight;
    }

    @Override
    public boolean renderFlushBottom() {
        return true;
    }

    @Override
    public boolean renderTranslucent() {
        return true;
    }

    @Override
    protected String getTexture() {
        return ((JSONVehicle)this.vehicle.definition).motorized.panelTexture != null ? ((JSONVehicle)this.vehicle.definition).motorized.panelTexture : this.definition.panel.texture;
    }

    private PartEngine getEngineBySwitchIndex(int index) {
        int engineIndex = 0;
        JSONPartDefinition engineDef = null;
        for (JSONPartDefinition partDef : ((JSONVehicle)this.vehicle.definition).parts) {
            for (String partType : partDef.types) {
                if (!partType.startsWith("engine_")) continue;
                if (engineIndex++ != index) break;
                engineDef = partDef;
                break;
            }
            if (engineDef == null) continue;
            break;
        }
        if (engineDef != null) {
            for (APart part : this.vehicle.parts) {
                if (part.placementDefinition != engineDef) continue;
                return (PartEngine)part;
            }
        } else {
            for (APart part : this.vehicle.parts) {
                if (!(part instanceof PartEngine) || this.vehicle.parts.contains(part) || engineIndex++ != index) continue;
                return (PartEngine)part;
            }
        }
        return null;
    }

    private void handleClickAction(JSONPanel.JSONPanelClickAction action) {
        ComputedVariable variable = this.vehicle.getOrCreateVariable(action.variable);
        switch (action.action) {
            case INCREMENT: {
                if (!(variable.currentValue + action.value >= (double)action.clampMin) || !(variable.currentValue + action.value <= (double)action.clampMax)) break;
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(variable, action.value));
                break;
            }
            case SET: {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(variable, action.value));
                break;
            }
            case TOGGLE: {
                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(variable));
            }
        }
    }

    private static class SwitchEntry {
        protected final AEntityE_Interactable<?> connectionDefiner;
        protected final EntityVehicleF_Physics vehicleOn;
        protected final JSONConnectionGroup connectionGroup;
        protected final int connectionGroupIndex;

        private SwitchEntry(AEntityE_Interactable<?> connectionDefiner, JSONConnectionGroup connectionGroup) {
            this.connectionDefiner = connectionDefiner;
            this.vehicleOn = connectionDefiner instanceof APart ? ((APart)connectionDefiner).vehicleOn : (EntityVehicleF_Physics)connectionDefiner;
            this.connectionGroup = connectionGroup;
            this.connectionGroupIndex = ((AJSONInteractableEntity)connectionDefiner.definition).connectionGroups.indexOf(connectionGroup);
        }

        protected boolean isConnected() {
            if (this.connectionGroup.isHookup && this.vehicleOn.towedByConnection != null && this.vehicleOn.towedByConnection.hookupGroupIndex == this.connectionGroupIndex) {
                return true;
            }
            if (this.connectionGroup.isHitch) {
                for (TowingConnection connection : this.vehicleOn.towingConnections) {
                    if (!this.connectionDefiner.equals(connection.towingEntity) || connection.hitchGroupIndex != this.connectionGroupIndex) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class GUIPanelTrimButton
    extends GUIPanelButton {
        private final ComputedVariable trimVariable;
        private final double leftIncrement;
        private final double bounds;
        private double trimIncrement;
        private boolean appliedTrimThisRender;
        private boolean trimCycleVar;

        private GUIPanelTrimButton(AGUIBase gui, JSONPanel.JSONPanelComponent component, ComputedVariable trimVariable, double leftIncrement, double bounds) {
            super(gui, component);
            this.trimVariable = trimVariable;
            this.leftIncrement = leftIncrement;
            this.bounds = bounds;
        }

        @Override
        public void onClicked(boolean leftSide) {
            this.trimIncrement = leftSide ? this.leftIncrement : -this.leftIncrement;
        }

        @Override
        public void onReleased() {
            this.trimIncrement = 0.0;
        }

        @Override
        public int getState() {
            if (this.trimIncrement != 0.0 && GUIPanel.inClockPeriod(3, 1)) {
                if (!this.appliedTrimThisRender) {
                    if (this.trimVariable.currentValue + this.trimIncrement > -this.bounds && this.trimVariable.currentValue + this.trimIncrement < this.bounds) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableIncrement(this.trimVariable, this.trimIncrement, -this.bounds, this.bounds));
                        this.trimCycleVar = !this.trimCycleVar;
                    }
                    this.appliedTrimThisRender = true;
                }
            } else {
                this.appliedTrimThisRender = false;
            }
            return this.trimCycleVar ? 1 : 0;
        }
    }

    private class GUIPanelEngineButton
    extends GUIPanelButton {
        private final PartEngine engine;

        private GUIPanelEngineButton(AGUIBase gui, JSONPanel.JSONPanelComponent component, PartEngine engine) {
            super(gui, component);
            this.engine = engine;
        }

        @Override
        public void onClicked(boolean leftSide) {
            block20: {
                block21: {
                    block19: {
                        if (this.component.specialComponent != JSONPanel.SpecialComponent.ENGINE_ON) break block19;
                        if (this.engine != null) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableToggle(this.engine.magnetoVar));
                        } else {
                            for (PartEngine engine : ((GUIPanel)GUIPanel.this).vehicle.engines) {
                                InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.magnetoVar, ((GUIPanel)GUIPanel.this).vehicle.enginesOn ? 0.0 : 1.0));
                            }
                        }
                        break block20;
                    }
                    if (this.component.specialComponent != JSONPanel.SpecialComponent.ENGINE_START) break block21;
                    if (!(this.engine != null ? this.engine.magnetoVar.isActive : ((GUIPanel)GUIPanel.this).vehicle.enginesOn)) break block20;
                    if (this.engine != null) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(this.engine.electricStarterVar, 1.0));
                    } else {
                        for (PartEngine engine : ((GUIPanel)GUIPanel.this).vehicle.engines) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.electricStarterVar, 1.0));
                        }
                    }
                    break block20;
                }
                if (leftSide) {
                    if (this.engine != null) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(this.engine.magnetoVar, 0.0));
                    } else {
                        for (PartEngine engine : ((GUIPanel)GUIPanel.this).vehicle.engines) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.magnetoVar, 0.0));
                        }
                    }
                } else if (this.engine != null ? this.engine.magnetoVar.isActive : ((GUIPanel)GUIPanel.this).vehicle.enginesOn) {
                    if (this.engine != null) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(this.engine.electricStarterVar, 1.0));
                    } else {
                        for (PartEngine engine : ((GUIPanel)GUIPanel.this).vehicle.engines) {
                            InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.electricStarterVar, 1.0));
                        }
                    }
                } else if (this.engine != null) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(this.engine.magnetoVar, 1.0));
                } else {
                    for (PartEngine engine : ((GUIPanel)GUIPanel.this).vehicle.engines) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.magnetoVar, 1.0));
                    }
                }
            }
        }

        @Override
        public void onReleased() {
            if (this.component.specialComponent == JSONPanel.SpecialComponent.ENGINE_CONTROL || this.component.specialComponent == JSONPanel.SpecialComponent.ENGINE_START) {
                if (this.engine != null) {
                    InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(this.engine.electricStarterVar, 0.0));
                } else {
                    for (PartEngine engine : ((GUIPanel)GUIPanel.this).vehicle.engines) {
                        InterfaceManager.packetInterface.sendToServer(new PacketEntityVariableSet(engine.electricStarterVar, 0.0));
                    }
                }
            }
        }

        @Override
        public int getState() {
            if (this.component.specialComponent == JSONPanel.SpecialComponent.ENGINE_ON) {
                return (this.engine != null ? this.engine.magnetoVar.isActive : ((GUIPanel)GUIPanel.this).vehicle.enginesOn) ? 1 : 0;
            }
            if (this.component.specialComponent == JSONPanel.SpecialComponent.ENGINE_START) {
                if (this.engine != null) {
                    return this.engine.magnetoVar.isActive ? (this.engine.electricStarterVar.isActive ? 2 : 1) : 0;
                }
                return ((GUIPanel)GUIPanel.this).vehicle.enginesOn ? (((GUIPanel)GUIPanel.this).vehicle.enginesStarting ? 2 : 1) : 0;
            }
            if (this.engine != null) {
                return this.engine.electricStarterVar.isActive ? 2 : (this.engine.magnetoVar.isActive ? 1 : 0);
            }
            return ((GUIPanel)GUIPanel.this).vehicle.enginesStarting ? 2 : (((GUIPanel)GUIPanel.this).vehicle.enginesOn ? 1 : 0);
        }
    }

    private abstract class GUIPanelButton
    extends GUIComponentButton {
        protected final JSONPanel.JSONPanelComponent component;

        private GUIPanelButton(AGUIBase gui, JSONPanel.JSONPanelComponent component) {
            super(gui, GUIPanel.this.guiLeft + (int)component.pos.x, GUIPanel.this.guiTop + (int)component.pos.y, component.width, component.height, (int)component.textureStart.x, (int)component.textureStart.y, component.width, component.height);
            this.component = component;
            this.isDynamicTexture = true;
            GUIPanel.this.componentButtons.add(this);
            GUIPanel.this.addComponent(this);
        }

        public int getState() {
            return this.component.statusVariable != null && GUIPanel.this.vehicle.getOrCreateVariable(this.component.statusVariable).getValue() > 0.0 ? 1 : 0;
        }
    }
}

