/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.JSONConfigEntry;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class GUIConfig
extends AGUIBase {
    private GUIComponentButton renderConfigScreenButton;
    private GUIComponentButton controlConfigScreenButton;
    private GUIComponentButton controlScreenButton;
    private boolean configuringControls = true;
    private boolean configuringRendering = false;
    private final Map<GUIComponentButton, JSONConfigEntry<Boolean>> renderConfigButtons = new HashMap<GUIComponentButton, JSONConfigEntry<Boolean>>();
    private final Map<GUIComponentButton, JSONConfigEntry<Boolean>> controlConfigButtons = new HashMap<GUIComponentButton, JSONConfigEntry<Boolean>>();
    private GUIComponentButton renderMode0Button;
    private GUIComponentButton renderMode1Button;
    private GUIComponentButton renderMode2Button;
    private ControlTypeEnum controlConfiguring;
    private final Map<GUIComponentButton, String> controlSelectionButtons = new HashMap<GUIComponentButton, String>();
    private GUIComponentLabel controlSelectionFaultLabel;
    private GUIComponentButton finishKeyboardBindingsButton;
    private GUIComponentButton soundVolumeUpButton;
    private GUIComponentButton soundVolumeDownButton;
    private GUIComponentLabel soundVolumeLabel;
    private GUIComponentButton radioVolumeUpButton;
    private GUIComponentButton radioVolumeDownButton;
    private GUIComponentLabel radioVolumeLabel;
    private boolean configuringKeyboard;
    private final Map<ControlTypeEnum, Map<GUIComponentTextBox, ControlSystem.ControlsKeyboard>> keyboardBoxes = new HashMap<ControlTypeEnum, Map<GUIComponentTextBox, ControlSystem.ControlsKeyboard>>();
    private final Map<ControlTypeEnum, Map<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>> keyboardLabels = new HashMap<ControlTypeEnum, Map<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>>();
    private final List<GUIComponentButton> joystickSelectionButtons = new ArrayList<GUIComponentButton>();
    private int scrollSpot = 0;
    private int selectedJoystickComponentCount = 0;
    private String selectedJoystickName;
    private GUIComponentButton componentListUpButton;
    private GUIComponentButton componentListDownButton;
    private GUIComponentButton deadzone_moreButton;
    private GUIComponentButton deadzone_lessButton;
    private GUIComponentTextBox deadzone_text;
    private final List<GUIComponentButton> joystickComponentSelectionButtons = new ArrayList<GUIComponentButton>();
    private final List<GUIComponentCutout> joystickComponentStateBackgrounds = new ArrayList<GUIComponentCutout>();
    private final List<GUIComponentCutout> joystickComponentStateForegrounds = new ArrayList<GUIComponentCutout>();
    private boolean assigningDigital;
    private int joystickComponentId = -1;
    private GUIComponentButton cancelAssignmentButton;
    private GUIComponentButton clearAssignmentButton;
    private final Map<ControlTypeEnum, List<Map<GUIComponentButton, ControlSystem.ControlsJoystick>>> digitalAssignButtons = new HashMap<ControlTypeEnum, List<Map<GUIComponentButton, ControlSystem.ControlsJoystick>>>();
    private int digitalAssignmentGroupIndex;
    private int digitalAssignmentGroupIndexMax;
    private GUIComponentButton assignmentListUpButton;
    private GUIComponentButton assignmentListDownButton;
    private static final int DIGITAL_ASSIGN_MAX_ROWS = 6;
    private final Map<ControlTypeEnum, Map<GUIComponentButton, ControlSystem.ControlsJoystick>> analogAssignButtons = new HashMap<ControlTypeEnum, Map<GUIComponentButton, ControlSystem.ControlsJoystick>>();
    private boolean calibrating = false;
    private ControlSystem.ControlsJoystick controlCalibrating;
    private GUIComponentButton confirmBoundsButton;
    private GUIComponentButton invertAxisButton;
    private GUIComponentTextBox axisMinBoundsTextBox;
    private GUIComponentTextBox axisMaxBoundsTextBox;

    public GUIConfig() {
        if (!InterfaceManager.inputInterface.isJoystickSupportEnabled()) {
            InterfaceManager.inputInterface.initJoysticks();
        }
    }

    @Override
    public void setupComponents() {
        int i;
        super.setupComponents();
        this.renderConfigScreenButton = new GUIComponentButton(this, this.guiLeft, this.guiTop - 20, 85, 20, LanguageSystem.GUI_CONFIG_HEADER_RENDERING.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.configuringControls = false;
                GUIConfig.this.configuringRendering = true;
                GUIConfig.this.controlConfiguring = null;
                GUIConfig.this.selectedJoystickName = null;
                GUIConfig.this.scrollSpot = 0;
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.renderConfigScreenButton);
        this.controlConfigScreenButton = new GUIComponentButton(this, this.guiLeft + 85, this.guiTop - 20, 85, 20, LanguageSystem.GUI_CONFIG_HEADER_CONFIG.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.configuringControls = false;
                GUIConfig.this.configuringRendering = false;
                GUIConfig.this.controlConfiguring = null;
                GUIConfig.this.selectedJoystickName = null;
                GUIConfig.this.scrollSpot = 0;
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.controlConfigScreenButton);
        this.controlScreenButton = new GUIComponentButton(this, this.guiLeft + 171, this.guiTop - 20, 85, 20, LanguageSystem.GUI_CONFIG_HEADER_CONTROLS.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.configuringControls = true;
            }
        };
        this.addComponent(this.controlScreenButton);
        this.populateConfigButtonList(this.renderConfigButtons, ConfigSystem.client.renderingSettings);
        this.populateConfigButtonList(this.controlConfigButtons, ConfigSystem.client.controlSettings);
        this.renderMode0Button = new GUIComponentButton(this, this.guiLeft + 20, this.guiTop + 160, 70, 20, LanguageSystem.GUI_CONFIG_RENDERING_MODE0.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.renderingSettings.renderingMode.value = 0;
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.renderMode0Button);
        this.renderMode1Button = new GUIComponentButton(this, this.guiLeft + 90, this.guiTop + 160, 70, 20, LanguageSystem.GUI_CONFIG_RENDERING_MODE1.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.renderingSettings.renderingMode.value = 1;
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.renderMode1Button);
        this.renderMode2Button = new GUIComponentButton(this, this.guiLeft + 160, this.guiTop + 160, 70, 20, LanguageSystem.GUI_CONFIG_RENDERING_MODE2.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.renderingSettings.renderingMode.value = 2;
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.renderMode2Button);
        this.addComponent(new GUIComponentLabel(this.guiLeft + 10, this.guiTop + 140, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_RENDERING_LABEL.getCurrentValue(), RenderText.TextAlignment.LEFT_ALIGNED, 0.75f, this.getWidth() - 20).setComponent(this.renderMode1Button));
        this.controlSelectionButtons.clear();
        this.controlSelectionFaultLabel = new GUIComponentLabel(this.guiLeft + 10, this.guiTop + 100, ColorRGB.BLACK, "", RenderText.TextAlignment.LEFT_ALIGNED, 0.8f, 240);
        this.addComponent(this.controlSelectionFaultLabel);
        for (ControlTypeEnum controlType : ControlTypeEnum.values()) {
            GUIComponentButton buttonKeyboard = new GUIComponentButton(this, this.guiLeft + this.getWidth() / 2 - 110, this.guiTop + 30 + 20 * this.controlSelectionButtons.size() / 2, 110, 20, controlType.keyboardLanguage.getCurrentValue()){

                @Override
                public void onClicked(boolean leftSide) {
                    String lookupString = (String)GUIConfig.this.controlSelectionButtons.get(this);
                    GUIConfig.this.controlConfiguring = ControlTypeEnum.valueOf(lookupString.substring(0, lookupString.indexOf(46)).toUpperCase());
                    GUIConfig.this.configuringKeyboard = true;
                }
            };
            this.controlSelectionButtons.put(buttonKeyboard, controlType.name().toLowerCase() + ".keyboard");
            this.addComponent(buttonKeyboard);
            GUIComponentButton buttonJoystick = new GUIComponentButton(this, this.guiLeft + this.getWidth() / 2, this.guiTop + 30 + 20 * (this.controlSelectionButtons.size() - 1) / 2, 110, 20, controlType.joystickLanguage.getCurrentValue()){

                @Override
                public void onClicked(boolean leftSide) {
                    String lookupString = (String)GUIConfig.this.controlSelectionButtons.get(this);
                    GUIConfig.this.controlConfiguring = ControlTypeEnum.valueOf(lookupString.substring(0, lookupString.indexOf(46)).toUpperCase());
                    GUIConfig.this.digitalAssignmentGroupIndexMax = ((List)GUIConfig.this.digitalAssignButtons.get((Object)GUIConfig.this.controlConfiguring)).size() - 1;
                    GUIConfig.this.configuringKeyboard = false;
                }
            };
            this.controlSelectionButtons.put(buttonJoystick, controlType.name().toLowerCase() + ".joystick");
            this.addComponent(buttonJoystick);
            if (this.controlSelectionButtons.size() != 1) continue;
            this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_CONTROLS_TITLE.getCurrentValue()).setComponent(buttonKeyboard));
        }
        this.soundVolumeUpButton = new GUIComponentButton(this, this.guiLeft + 40, this.guiTop + 140, 20, 20, "/\\"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.controlSettings.soundVolume.value = Float.valueOf((float)((int)(((Float)ConfigSystem.client.controlSettings.soundVolume.value).floatValue() * 10.0f) + 1) / 10.0f);
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.soundVolumeUpButton);
        this.soundVolumeDownButton = new GUIComponentButton(this, this.guiLeft + 188, this.guiTop + 140, 20, 20, "\\/"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.controlSettings.soundVolume.value = Float.valueOf((float)((int)(((Float)ConfigSystem.client.controlSettings.soundVolume.value).floatValue() * 10.0f) - 1) / 10.0f);
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.soundVolumeDownButton);
        this.soundVolumeLabel = new GUIComponentLabel(this.guiLeft + 128, this.guiTop + 145, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_CONTROLS_SOUNDVOLUME.getCurrentValue() + ConfigSystem.client.controlSettings.soundVolume.value, RenderText.TextAlignment.CENTERED, 1.0f);
        this.addComponent(this.soundVolumeLabel);
        this.soundVolumeLabel.setComponent(this.soundVolumeDownButton);
        this.radioVolumeUpButton = new GUIComponentButton(this, this.soundVolumeUpButton.constructedX, this.soundVolumeUpButton.constructedY + this.soundVolumeUpButton.height, this.soundVolumeUpButton.width, this.soundVolumeUpButton.height, "/\\"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.controlSettings.radioVolume.value = Float.valueOf((float)((int)(((Float)ConfigSystem.client.controlSettings.radioVolume.value).floatValue() * 10.0f) + 1) / 10.0f);
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.radioVolumeUpButton);
        this.radioVolumeDownButton = new GUIComponentButton(this, this.soundVolumeDownButton.constructedX, this.soundVolumeDownButton.constructedY + this.soundVolumeDownButton.height, this.soundVolumeDownButton.width, this.soundVolumeDownButton.height, "\\/"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.controlSettings.radioVolume.value = Float.valueOf((float)((int)(((Float)ConfigSystem.client.controlSettings.radioVolume.value).floatValue() * 10.0f) - 1) / 10.0f);
                ConfigSystem.saveToDisk();
            }
        };
        this.addComponent(this.radioVolumeDownButton);
        this.radioVolumeLabel = new GUIComponentLabel(this.soundVolumeLabel.constructedX, this.soundVolumeLabel.constructedY + this.soundVolumeDownButton.height, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_CONTROLS_RADIOVOLUME.getCurrentValue() + ConfigSystem.client.controlSettings.soundVolume.value, RenderText.TextAlignment.CENTERED, 1.0f);
        this.addComponent(this.radioVolumeLabel);
        this.radioVolumeLabel.setComponent(this.radioVolumeDownButton);
        this.keyboardBoxes.clear();
        this.keyboardLabels.clear();
        for (ControlTypeEnum controlType : ControlTypeEnum.values()) {
            int verticalOffset = 20;
            int horizontalOffset = 80;
            HashMap<13, ControlSystem.ControlsKeyboard> boxesForControls = new HashMap<13, ControlSystem.ControlsKeyboard>();
            for (ControlSystem.ControlsKeyboard keyboardControl : ControlSystem.ControlsKeyboard.values()) {
                if (!keyboardControl.systemName.contains(controlType.name().toLowerCase())) continue;
                GUIComponentTextBox box = new GUIComponentTextBox(this, this.guiLeft + horizontalOffset, this.guiTop + verticalOffset, 40, 10, "", ColorRGB.WHITE, 5){

                    @Override
                    public void handleKeyTyped(char typedChar, int typedCode, GUIComponentTextBox.TextBoxControlKey control) {
                        this.setText(InterfaceManager.inputInterface.getNameForKeyCode(typedCode));
                        ((ControlSystem.ControlsKeyboard)((Object)((Map)((GUIConfig)GUIConfig.this).keyboardBoxes.get((Object)((Object)((GUIConfig)GUIConfig.this).controlConfiguring))).get((Object)this))).config.keyCode = typedCode;
                        ConfigSystem.saveToDisk();
                        this.focused = false;
                    }
                };
                boxesForControls.put(box, keyboardControl);
                this.addComponent(box);
                this.addComponent(new GUIComponentLabel(box.constructedX - 70, box.constructedY + 2, ColorRGB.BLACK, keyboardControl.language.getCurrentValue() + ":").setComponent(box));
                if ((verticalOffset += 11) <= 119) continue;
                verticalOffset = 20;
                horizontalOffset += 120;
            }
            this.keyboardBoxes.put(controlType, boxesForControls);
            int offset = 0;
            HashMap<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic> dynamicLabels = new HashMap<GUIComponentLabel, ControlSystem.ControlsKeyboardDynamic>();
            ControlSystem.ControlsKeyboardDynamic[] controlsKeyboardDynamicArray = ControlSystem.ControlsKeyboardDynamic.values();
            int n = controlsKeyboardDynamicArray.length;
            for (int box = 0; box < n; ++box) {
                ControlSystem.ControlsKeyboardDynamic dynamicControl = controlsKeyboardDynamicArray[box];
                if (!dynamicControl.name().toLowerCase(Locale.ROOT).contains(controlType.name().toLowerCase())) continue;
                GUIComponentLabel label = new GUIComponentLabel(this.guiLeft + 10, this.guiTop + 135 + offset, ColorRGB.BLACK, "");
                dynamicLabels.put(label, dynamicControl);
                this.addComponent(label);
                offset = (byte)(offset + 11);
            }
            this.keyboardLabels.put(controlType, dynamicLabels);
        }
        this.finishKeyboardBindingsButton = new GUIComponentButton(this, this.guiLeft + 180, this.guiTop + 150, 50, 20, LanguageSystem.GUI_CONFIRM.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.controlConfiguring = null;
            }
        };
        this.addComponent(this.finishKeyboardBindingsButton);
        this.joystickSelectionButtons.clear();
        for (i = 0; i < 9; ++i) {
            GUIComponentButton button = new GUIComponentButton(this, this.guiLeft + 10, this.guiTop + 40 + 20 * this.joystickSelectionButtons.size(), 235, 20, ""){

                @Override
                public void onClicked(boolean leftSide) {
                    GUIConfig.this.selectedJoystickName = InterfaceManager.inputInterface.getAllJoystickNames().get(GUIConfig.this.joystickSelectionButtons.indexOf(this));
                    GUIConfig.this.selectedJoystickComponentCount = InterfaceManager.inputInterface.getJoystickComponentCount(GUIConfig.this.selectedJoystickName);
                }
            };
            this.joystickSelectionButtons.add(button);
            this.addComponent(button);
            if (this.joystickSelectionButtons.size() != 1) continue;
            this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_SELECT.getCurrentValue()).setComponent(button));
            this.addComponent(new GUIComponentLabel(this.guiLeft + 15, this.guiTop + 25, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_NAME.getCurrentValue()).setComponent(button));
        }
        this.joystickComponentSelectionButtons.clear();
        this.joystickComponentStateBackgrounds.clear();
        this.joystickComponentStateForegrounds.clear();
        for (i = 0; i < 9; ++i) {
            GUIComponentButton button = new GUIComponentButton(this, this.guiLeft + 10, this.guiTop + 45 + 15 * i, 215, 15, "", false, ColorRGB.DARK_GRAY, true){

                @Override
                public void onClicked(boolean leftSide) {
                    GUIConfig.this.joystickComponentId = GUIConfig.this.joystickComponentSelectionButtons.indexOf(this) + GUIConfig.this.scrollSpot;
                    GUIConfig.this.assigningDigital = !InterfaceManager.inputInterface.isJoystickComponentAxis(GUIConfig.this.selectedJoystickName, GUIConfig.this.joystickComponentId);
                }
            };
            this.joystickComponentSelectionButtons.add(button);
            this.addComponent(button);
            GUIComponentCutout componentBackground = new GUIComponentCutout(this, button.constructedX + 100, button.constructedY + 2, 40, 10, 236, 236, 20, 20);
            this.joystickComponentStateBackgrounds.add(componentBackground);
            this.addComponent(componentBackground);
            GUIComponentCutout componentForeground = new GUIComponentCutout(this, button.constructedX + 100, button.constructedY + 2, 40, 10, 236, 0, 20, 20);
            this.joystickComponentStateForegrounds.add(componentForeground);
            this.addComponent(componentForeground);
        }
        this.componentListUpButton = new GUIComponentButton(this, this.guiLeft + 225, this.guiTop + 45, 20, 20, "/\\"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.scrollSpot -= 9;
            }
        };
        this.addComponent(this.componentListUpButton);
        this.componentListDownButton = new GUIComponentButton(this, this.guiLeft + 225, this.guiTop + 155, 20, 20, "\\/"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.scrollSpot += 9;
            }
        };
        this.addComponent(this.componentListDownButton);
        this.deadzone_lessButton = new GUIComponentButton(this, this.guiLeft + 100, this.guiTop + 10, 20, 20, "<"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.controlSettings.joystickDeadZone.value = ((Double)ConfigSystem.client.controlSettings.joystickDeadZone.value * 100.0 - 1.0) / 100.0;
            }
        };
        this.addComponent(this.deadzone_lessButton);
        this.deadzone_moreButton = new GUIComponentButton(this, this.guiLeft + 220, this.guiTop + 10, 20, 20, ">"){

            @Override
            public void onClicked(boolean leftSide) {
                ConfigSystem.client.controlSettings.joystickDeadZone.value = ((Double)ConfigSystem.client.controlSettings.joystickDeadZone.value * 100.0 + 1.0) / 100.0;
            }
        };
        this.addComponent(this.deadzone_moreButton);
        this.deadzone_text = new GUIComponentTextBox((AGUIBase)this, this.guiLeft + 120, this.guiTop + 10, 100, "");
        this.addComponent(this.deadzone_text);
        this.addComponent(new GUIComponentLabel(this.guiLeft + 15, this.guiTop + 20, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_MAPPING.getCurrentValue()).setComponent(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 15, this.guiTop + 35, ColorRGB.BLACK, "#").setComponent(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 30, this.guiTop + 35, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_NAME.getCurrentValue()).setComponent(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 100, this.guiTop + 35, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_STATE.getCurrentValue()).setComponent(this.componentListUpButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 140, this.guiTop + 35, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_ASSIGNMENT.getCurrentValue()).setComponent(this.componentListUpButton));
        this.assignmentListUpButton = new GUIComponentButton(this, this.guiLeft + 225, this.guiTop + 45, 20, 20, "/\\"){

            @Override
            public void onClicked(boolean leftSide) {
                --GUIConfig.this.digitalAssignmentGroupIndex;
            }
        };
        this.addComponent(this.assignmentListUpButton);
        this.assignmentListDownButton = new GUIComponentButton(this, this.guiLeft + 225, this.guiTop + 155, 20, 20, "\\/"){

            @Override
            public void onClicked(boolean leftSide) {
                ++GUIConfig.this.digitalAssignmentGroupIndex;
            }
        };
        this.addComponent(this.assignmentListDownButton);
        this.cancelAssignmentButton = new GUIComponentButton(this, this.guiLeft + 125, this.guiTop + 160, 100, 20, LanguageSystem.GUI_CONFIG_JOYSTICK_CANCEL.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.cancelAssignmentButton);
        this.clearAssignmentButton = new GUIComponentButton(this, this.guiLeft + 25, this.guiTop + 160, 100, 20, LanguageSystem.GUI_CONFIG_JOYSTICK_CLEAR.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                    if (!GUIConfig.this.selectedJoystickName.equals(joystickControl.config.joystickName) || !(joystickControl.isAxis ^ GUIConfig.this.assigningDigital) || joystickControl.config.buttonIndex != GUIConfig.this.joystickComponentId || !joystickControl.systemName.startsWith(GUIConfig.this.controlConfiguring.name().toLowerCase())) continue;
                    joystickControl.clearControl();
                }
                GUIConfig.this.joystickComponentId = -1;
            }
        };
        this.addComponent(this.clearAssignmentButton);
        this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_CHOOSEMAP.getCurrentValue()).setComponent(this.clearAssignmentButton));
        this.digitalAssignButtons.clear();
        this.analogAssignButtons.clear();
        for (ControlTypeEnum controlType : ControlTypeEnum.values()) {
            int topOffsetDigital = 0;
            int topOffsetAnalog = 0;
            HashMap<25, ControlSystem.ControlsJoystick> digitalControlButtons = new HashMap<25, ControlSystem.ControlsJoystick>();
            HashMap<25, ControlSystem.ControlsJoystick> analogControlButtons = new HashMap<25, ControlSystem.ControlsJoystick>();
            this.digitalAssignButtons.put(controlType, new ArrayList());
            for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                GUIComponentButton button;
                if (!joystickControl.systemName.startsWith(controlType.name().toLowerCase())) continue;
                if (!joystickControl.isAxis) {
                    button = new GUIComponentButton(this, this.guiLeft + 65, this.guiTop + 30 + topOffsetDigital, 120, 20, joystickControl.language.getCurrentValue()){

                        @Override
                        public void onClicked(boolean leftSide) {
                            ((ControlSystem.ControlsJoystick)((Object)((Map)((List)GUIConfig.this.digitalAssignButtons.get((Object)GUIConfig.this.controlConfiguring)).get(GUIConfig.this.digitalAssignmentGroupIndex)).get(this))).setControl(GUIConfig.this.selectedJoystickName, GUIConfig.this.joystickComponentId);
                            GUIConfig.this.joystickComponentId = -1;
                        }
                    };
                    digitalControlButtons.put(button, joystickControl);
                    if (digitalControlButtons.size() == 6) {
                        HashMap<25, ControlSystem.ControlsJoystick> copiedMap = new HashMap<25, ControlSystem.ControlsJoystick>();
                        copiedMap.putAll(digitalControlButtons);
                        this.digitalAssignButtons.get((Object)controlType).add(copiedMap);
                        digitalControlButtons.clear();
                        topOffsetDigital = 0;
                    } else {
                        topOffsetDigital = (short)(topOffsetDigital + button.height);
                    }
                    this.addComponent(button);
                    continue;
                }
                button = new GUIComponentButton(this, this.guiLeft + 85, this.guiTop + 40 + topOffsetAnalog, 80, 20, joystickControl.language.getCurrentValue()){

                    @Override
                    public void onClicked(boolean leftSide) {
                        GUIConfig.this.controlCalibrating = (ControlSystem.ControlsJoystick)((Object)((Map)GUIConfig.this.analogAssignButtons.get((Object)GUIConfig.this.controlConfiguring)).get(this));
                        GUIConfig.this.axisMinBoundsTextBox.setText("0.0");
                        GUIConfig.this.axisMaxBoundsTextBox.setText("0.0");
                        GUIConfig.this.calibrating = true;
                    }
                };
                analogControlButtons.put(button, joystickControl);
                this.addComponent(button);
                topOffsetAnalog = (short)(topOffsetAnalog + button.height);
            }
            this.digitalAssignButtons.get((Object)controlType).add(digitalControlButtons);
            this.analogAssignButtons.put(controlType, analogControlButtons);
        }
        this.confirmBoundsButton = new GUIComponentButton(this, this.guiLeft + 25, this.guiTop + 160, 100, 20, LanguageSystem.GUI_CONFIRM.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                boolean isInverted = ((GUIConfig)GUIConfig.this).invertAxisButton.text.contains(LanguageSystem.GUI_CONFIG_JOYSTICK_INVERT.getCurrentValue());
                GUIConfig.this.controlCalibrating.setAxisControl(GUIConfig.this.selectedJoystickName, GUIConfig.this.joystickComponentId, Double.parseDouble(GUIConfig.this.axisMinBoundsTextBox.getText()), Double.parseDouble(GUIConfig.this.axisMaxBoundsTextBox.getText()), isInverted);
                GUIConfig.this.joystickComponentId = -1;
                GUIConfig.this.calibrating = false;
            }
        };
        this.addComponent(this.confirmBoundsButton);
        this.invertAxisButton = new GUIComponentButton(this, this.guiLeft + 50, this.guiTop + 120, 150, 20, LanguageSystem.GUI_CONFIG_JOYSTICK_AXISMODE.getCurrentValue() + LanguageSystem.GUI_CONFIG_JOYSTICK_NORMAL.getCurrentValue()){

            @Override
            public void onClicked(boolean leftSide) {
                this.text = this.text.contains(LanguageSystem.GUI_CONFIG_JOYSTICK_INVERT.getCurrentValue()) ? LanguageSystem.GUI_CONFIG_JOYSTICK_AXISMODE.getCurrentValue() + LanguageSystem.GUI_CONFIG_JOYSTICK_NORMAL.getCurrentValue() : LanguageSystem.GUI_CONFIG_JOYSTICK_AXISMODE.getCurrentValue() + LanguageSystem.GUI_CONFIG_JOYSTICK_INVERT.getCurrentValue();
            }
        };
        this.addComponent(this.invertAxisButton);
        this.axisMinBoundsTextBox = new GUIComponentTextBox((AGUIBase)this, this.guiLeft + 50, this.guiTop + 90, 150, "0.0");
        this.addComponent(this.axisMinBoundsTextBox);
        this.axisMinBoundsTextBox.enabled = false;
        this.axisMaxBoundsTextBox = new GUIComponentTextBox((AGUIBase)this, this.guiLeft + 50, this.guiTop + 60, 150, "0.0");
        this.addComponent(this.axisMaxBoundsTextBox);
        this.axisMaxBoundsTextBox.enabled = false;
        this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 10, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_CALIBRATE1.getCurrentValue()).setComponent(this.confirmBoundsButton));
        this.addComponent(new GUIComponentLabel(this.guiLeft + 20, this.guiTop + 20, ColorRGB.BLACK, LanguageSystem.GUI_CONFIG_JOYSTICK_CALIBRATE2.getCurrentValue()).setComponent(this.confirmBoundsButton));
    }

    @Override
    public void setStates() {
        super.setStates();
        this.renderConfigScreenButton.enabled = this.configuringControls || !this.configuringControls && !this.configuringRendering;
        this.controlConfigScreenButton.enabled = this.configuringControls || !this.configuringControls && this.configuringRendering;
        this.controlScreenButton.enabled = !this.configuringControls;
        for (GUIComponentButton button : this.renderConfigButtons.keySet()) {
            button.visible = !this.renderConfigScreenButton.enabled;
        }
        this.renderMode0Button.visible = !this.renderConfigScreenButton.enabled;
        this.renderMode0Button.enabled = (Integer)ConfigSystem.client.renderingSettings.renderingMode.value != 0;
        this.renderMode1Button.visible = !this.renderConfigScreenButton.enabled;
        this.renderMode1Button.enabled = (Integer)ConfigSystem.client.renderingSettings.renderingMode.value != 1;
        this.renderMode2Button.visible = !this.renderConfigScreenButton.enabled;
        this.renderMode2Button.enabled = (Integer)ConfigSystem.client.renderingSettings.renderingMode.value != 2;
        for (GUIComponentButton button : this.controlConfigButtons.keySet()) {
            button.visible = !this.controlConfigScreenButton.enabled;
        }
        boolean bl = this.controlSelectionFaultLabel.visible = !InterfaceManager.inputInterface.isJoystickSupportEnabled() && this.configuringControls && !this.configuringKeyboard;
        if (this.controlSelectionFaultLabel.visible) {
            this.controlSelectionFaultLabel.text = InterfaceManager.inputInterface.isJoystickSupportBlocked() ? LanguageSystem.GUI_CONFIG_JOYSTICK_DISABLED.getCurrentValue() : LanguageSystem.GUI_CONFIG_JOYSTICK_ERROR.getCurrentValue();
        }
        for (GUIComponentButton button : this.controlSelectionButtons.keySet()) {
            button.visible = this.configuringControls && this.controlConfiguring == null && (!this.controlSelectionButtons.get(button).endsWith(".joystick") || InterfaceManager.inputInterface.isJoystickSupportEnabled());
        }
        if (!this.configuringControls && !this.configuringRendering) {
            this.soundVolumeUpButton.visible = true;
            this.soundVolumeUpButton.enabled = (double)((Float)ConfigSystem.client.controlSettings.soundVolume.value).floatValue() < 1.5;
            this.soundVolumeDownButton.visible = true;
            this.soundVolumeDownButton.enabled = ((Float)ConfigSystem.client.controlSettings.soundVolume.value).floatValue() > 0.0f;
            this.soundVolumeLabel.text = LanguageSystem.GUI_CONFIG_CONTROLS_SOUNDVOLUME.getCurrentValue() + ConfigSystem.client.controlSettings.soundVolume.value;
            this.radioVolumeUpButton.visible = true;
            this.radioVolumeUpButton.enabled = (double)((Float)ConfigSystem.client.controlSettings.radioVolume.value).floatValue() < 1.5;
            this.radioVolumeDownButton.visible = true;
            this.radioVolumeDownButton.enabled = ((Float)ConfigSystem.client.controlSettings.radioVolume.value).floatValue() > 0.0f;
            this.radioVolumeLabel.text = LanguageSystem.GUI_CONFIG_CONTROLS_RADIOVOLUME.getCurrentValue() + ConfigSystem.client.controlSettings.radioVolume.value;
        } else {
            this.soundVolumeUpButton.visible = false;
            this.soundVolumeDownButton.visible = false;
            this.radioVolumeUpButton.visible = false;
            this.radioVolumeDownButton.visible = false;
        }
        this.finishKeyboardBindingsButton.visible = this.configuringControls && this.controlConfiguring != null && this.configuringKeyboard;
        for (ControlTypeEnum controlType : this.keyboardBoxes.keySet()) {
            for (GUIComponentTextBox textBox : this.keyboardBoxes.get((Object)controlType).keySet()) {
                boolean bl2 = textBox.visible = this.finishKeyboardBindingsButton.visible && controlType.equals((Object)this.controlConfiguring);
                if (textBox.focused) {
                    textBox.setText("");
                    continue;
                }
                textBox.setText(InterfaceManager.inputInterface.getNameForKeyCode(this.keyboardBoxes.get((Object)((Object)controlType)).get((Object)textBox).config.keyCode));
            }
            for (GUIComponentLabel label : this.keyboardLabels.get((Object)controlType).keySet()) {
                label.visible = this.finishKeyboardBindingsButton.visible && controlType.equals((Object)this.controlConfiguring);
                ControlSystem.ControlsKeyboardDynamic dynamicControl = this.keyboardLabels.get((Object)controlType).get(label);
                label.text = dynamicControl.language.getCurrentValue() + ": " + InterfaceManager.inputInterface.getNameForKeyCode(dynamicControl.modControl.config.keyCode) + " + " + InterfaceManager.inputInterface.getNameForKeyCode(dynamicControl.mainControl.config.keyCode);
            }
        }
        List<String> allJoystickNames = InterfaceManager.inputInterface.getAllJoystickNames();
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            GUIComponentButton button = this.joystickSelectionButtons.get(i);
            if (allJoystickNames.size() > i) {
                button.visible = this.configuringControls && !this.configuringKeyboard && this.controlConfiguring != null && this.selectedJoystickName == null;
                button.text = String.format(" %-30.28s", allJoystickNames.get(i));
                continue;
            }
            button.visible = false;
        }
        boolean onComponentSelectScreen = this.selectedJoystickName != null && this.joystickComponentId == -1;
        for (int i = 0; i < 9; i = (int)((byte)(i + 1))) {
            GUIComponentButton button = this.joystickComponentSelectionButtons.get(i);
            GUIComponentCutout componentBackground = this.joystickComponentStateBackgrounds.get(i);
            GUIComponentCutout componentForeground = this.joystickComponentStateForegrounds.get(i);
            componentBackground.visible = button.visible = onComponentSelectScreen && i + this.scrollSpot < this.selectedJoystickComponentCount;
            componentForeground.visible = button.visible;
            if (!button.visible) continue;
            int n = i + this.scrollSpot;
            button.text = String.format(" %02d  %-15.15s", n + 1, InterfaceManager.inputInterface.getJoystickComponentName(this.selectedJoystickName, n));
            for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                if (!this.selectedJoystickName.equals(joystickControl.config.joystickName) || joystickControl.config.buttonIndex != n || !joystickControl.systemName.startsWith(this.controlConfiguring.name().toLowerCase())) continue;
                button.text = button.text + String.format("          %s", joystickControl.language.getCurrentValue());
            }
            float pollData = InterfaceManager.inputInterface.getJoystickAxisValue(this.selectedJoystickName, n);
            if (InterfaceManager.inputInterface.isJoystickComponentAxis(this.selectedJoystickName, n)) {
                int pollDataInt = (int)(pollData * 20.0f);
                componentBackground.visible = true;
                componentForeground.position.x = componentForeground.constructedX;
                if (pollDataInt > 0) {
                    componentForeground.position.x += 20.0;
                    componentForeground.width = pollDataInt;
                } else {
                    componentForeground.position.x += (double)(20 + pollDataInt);
                    componentForeground.width = -pollDataInt;
                }
                componentForeground.textureYOffset = 196;
                continue;
            }
            componentBackground.visible = false;
            componentForeground.position.x = componentForeground.constructedX + 15;
            componentForeground.width = 10;
            componentForeground.textureYOffset = pollData == 0.0f ? 236 : (pollData == 1.0f ? 196 : 216);
        }
        this.componentListUpButton.visible = onComponentSelectScreen;
        this.componentListDownButton.visible = onComponentSelectScreen;
        this.deadzone_lessButton.visible = onComponentSelectScreen;
        this.deadzone_moreButton.visible = onComponentSelectScreen;
        this.deadzone_text.visible = onComponentSelectScreen;
        if (onComponentSelectScreen) {
            this.componentListUpButton.enabled = this.scrollSpot - 9 >= 0;
            this.componentListDownButton.enabled = this.scrollSpot + 9 < this.selectedJoystickComponentCount;
            this.deadzone_lessButton.enabled = (Double)ConfigSystem.client.controlSettings.joystickDeadZone.value > 0.0;
            this.deadzone_moreButton.enabled = (Double)ConfigSystem.client.controlSettings.joystickDeadZone.value < 1.0;
            this.deadzone_text.enabled = false;
            this.deadzone_text.setText(LanguageSystem.GUI_CONFIG_JOYSTICK_DEADZONE.getCurrentValue() + " " + ConfigSystem.client.controlSettings.joystickDeadZone.value);
        }
        this.assignmentListUpButton.visible = this.joystickComponentId != -1;
        this.assignmentListUpButton.enabled = this.digitalAssignmentGroupIndex > 0;
        this.assignmentListDownButton.visible = this.assignmentListUpButton.visible;
        this.assignmentListDownButton.enabled = this.digitalAssignmentGroupIndex < this.digitalAssignmentGroupIndexMax;
        this.cancelAssignmentButton.visible = this.assignmentListUpButton.visible;
        this.cancelAssignmentButton.enabled = this.assignmentListUpButton.visible;
        this.clearAssignmentButton.visible = this.assignmentListUpButton.visible && !this.calibrating;
        this.clearAssignmentButton.enabled = this.assignmentListUpButton.visible && !this.calibrating;
        for (ControlTypeEnum controlType : this.digitalAssignButtons.keySet()) {
            int buttonSectionIndex = 0;
            for (Map map : this.digitalAssignButtons.get((Object)controlType)) {
                for (GUIComponentButton button : map.keySet()) {
                    button.visible = this.joystickComponentId != -1 && controlType.equals((Object)this.controlConfiguring) && this.assigningDigital && this.digitalAssignmentGroupIndex == buttonSectionIndex;
                }
                ++buttonSectionIndex;
            }
        }
        for (ControlTypeEnum controlType : this.analogAssignButtons.keySet()) {
            for (GUIComponentButton button : this.analogAssignButtons.get((Object)controlType).keySet()) {
                button.visible = this.joystickComponentId != -1 && controlType.equals((Object)this.controlConfiguring) && !this.assigningDigital && !this.calibrating;
            }
        }
        this.confirmBoundsButton.visible = this.calibrating;
        this.cancelAssignmentButton.visible = this.calibrating;
        this.invertAxisButton.visible = this.calibrating;
        this.axisMinBoundsTextBox.visible = this.calibrating;
        this.axisMaxBoundsTextBox.visible = this.calibrating;
        if (this.calibrating) {
            float pollData = InterfaceManager.inputInterface.getJoystickAxisValue(this.selectedJoystickName, this.joystickComponentId);
            if (pollData < 0.0f) {
                this.axisMinBoundsTextBox.setText(String.valueOf(Math.min(Double.parseDouble(this.axisMinBoundsTextBox.getText()), (double)pollData)));
            } else {
                this.axisMaxBoundsTextBox.setText(String.valueOf(Math.max(Double.parseDouble(this.axisMaxBoundsTextBox.getText()), (double)pollData)));
            }
        }
    }

    private void populateConfigButtonList(final Map<GUIComponentButton, JSONConfigEntry<Boolean>> configButtons, Object configObject) {
        configButtons.clear();
        for (Field field : configObject.getClass().getFields()) {
            if (!field.getType().equals(JSONConfigEntry.class)) continue;
            try {
                final JSONConfigEntry configEntry = (JSONConfigEntry)field.get(configObject);
                if (!configEntry.value.getClass().equals(Boolean.class)) continue;
                GUIComponentButton button = new GUIComponentButton(this, this.guiLeft + 85 + 120 * (configButtons.size() % 2), this.guiTop + 20 + 16 * (configButtons.size() / 2), 40, 16, String.valueOf(configEntry.value)){

                    @Override
                    public void onClicked(boolean leftSide) {
                        ((JSONConfigEntry)configButtons.get((Object)this)).value = !Boolean.parseBoolean(this.text);
                        ConfigSystem.saveToDisk();
                        this.text = String.valueOf(((JSONConfigEntry)configButtons.get((Object)this)).value);
                    }

                    @Override
                    public List<String> getTooltipText() {
                        ArrayList<String> tooltipText = new ArrayList<String>();
                        tooltipText.add(configEntry.comment);
                        return tooltipText;
                    }
                };
                this.addComponent(button);
                configButtons.put(button, configEntry);
                this.addComponent(new GUIComponentLabel(button.constructedX - 75, button.constructedY + 5, ColorRGB.BLACK, field.getName()).setComponent(button));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static enum ControlTypeEnum {
        GENERAL(LanguageSystem.GUI_CONFIG_CONTROLS_GENERAL_KEYBOARD, LanguageSystem.GUI_CONFIG_CONTROLS_GENERAL_JOYSTICK),
        CAR(LanguageSystem.GUI_CONFIG_CONTROLS_CAR_KEYBOARD, LanguageSystem.GUI_CONFIG_CONTROLS_CAR_JOYSTICK),
        AIRCRAFT(LanguageSystem.GUI_CONFIG_CONTROLS_AIRCRAFT_KEYBOARD, LanguageSystem.GUI_CONFIG_CONTROLS_AIRCRAFT_JOYSTICK);

        private final LanguageSystem.LanguageEntry keyboardLanguage;
        private final LanguageSystem.LanguageEntry joystickLanguage;

        private ControlTypeEnum(LanguageSystem.LanguageEntry keyboardEntry, LanguageSystem.LanguageEntry joystickEntry) {
            this.keyboardLanguage = keyboardEntry;
            this.joystickLanguage = joystickEntry;
        }
    }
}

