/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentItem;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public abstract class AGUIInventory
extends AGUIBase {
    public static final int MAX_ITEMS_PER_SCREEN = 54;
    private final String texture;
    protected final IWrapperPlayer player;
    protected final IWrapperInventory playerInventory;
    private final List<GUIComponentButton> playerSlotButtons = new ArrayList<GUIComponentButton>();
    private final List<GUIComponentItem> playerSlotIcons = new ArrayList<GUIComponentItem>();
    protected final List<GUIComponentButton> interactableSlotButtons = new ArrayList<GUIComponentButton>();
    protected final List<GUIComponentItem> interactableSlotIcons = new ArrayList<GUIComponentItem>();

    public AGUIInventory(String texture) {
        this.texture = texture != null ? texture : "mts:textures/guis/inventory.png";
        this.player = InterfaceManager.clientInterface.getClientPlayer();
        this.playerInventory = this.player.getInventory();
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        this.playerSlotButtons.clear();
        this.playerSlotIcons.clear();
        int yOffset = this.getPlayerInventoryOffset();
        for (int i = 0; i < 36; i = (int)((byte)(i + 1))) {
            GUIComponentButton itemButton = new GUIComponentButton(this, this.guiLeft + 7 + 18 * (i % 9), this.guiTop + yOffset, false){

                @Override
                public void onClicked(boolean leftSide) {
                    AGUIInventory.this.handlePlayerItemClick(AGUIInventory.this.playerSlotButtons.indexOf(this));
                }
            };
            this.addComponent(itemButton);
            this.playerSlotButtons.add(itemButton);
            GUIComponentItem itemIcon = new GUIComponentItem(itemButton);
            this.addComponent(itemIcon);
            this.playerSlotIcons.add(itemIcon);
            if (i == 8) {
                yOffset -= 58;
                continue;
            }
            if (i != 17 && i != 26) continue;
            yOffset += 18;
        }
        this.interactableSlotButtons.clear();
        this.interactableSlotIcons.clear();
    }

    @Override
    public void setStates() {
        super.setStates();
        for (int i = 0; i < this.playerSlotButtons.size(); ++i) {
            IWrapperItemStack stack = this.playerInventory.getStack(i);
            this.playerSlotButtons.get((int)i).enabled = !stack.isEmpty();
            this.playerSlotIcons.get((int)i).stack = stack;
        }
    }

    protected abstract void handlePlayerItemClick(int var1);

    protected int getPlayerInventoryOffset() {
        return 197;
    }

    @Override
    public int getWidth() {
        return 194;
    }

    @Override
    public int getHeight() {
        return 221;
    }

    @Override
    protected String getTexture() {
        return this.texture;
    }
}

