/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.components;

import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponentCutout;
import minecrafttransportsimulator.rendering.RenderText;
import minecrafttransportsimulator.rendering.RenderableData;
import minecrafttransportsimulator.rendering.RenderableVertices;

public abstract class GUIComponentButton
extends GUIComponentCutout {
    private static final int DEFAULT_BUTTON_SECTION_WIDTH = 100;
    private static final int DEFAULT_BUTTON_SECTION_HEIGHT = 20;
    private static final int DEFAULT_BUTTON_SECTION_BORDER = 6;
    private static final int DEFAULT_BUTTON_SECTION_WIDTH_OFFSET = 0;
    private static final int DEFAULT_BUTTON_SECTION_HEIGHT_OFFSET = 196;
    public static final int ITEM_BUTTON_SIZE = 18;
    public final boolean centeredText;
    public boolean enabled = true;
    public boolean isDynamicTexture;
    public final ColorRGB textColor;
    protected RenderableData renderable2;
    protected RenderableData renderable2L;
    protected RenderableData renderable3;
    protected RenderableData renderable3L;

    public GUIComponentButton(AGUIBase gui, int x, int y, int width, int height, String text) {
        this(gui, x, y, width, height, text, true, ColorRGB.DARK_GRAY, 0, 196, 100, 20);
    }

    public GUIComponentButton(AGUIBase gui, int x, int y, boolean renderBackground) {
        this(gui, x, y, 18, 18, renderBackground ? 194 : 0, 0, renderBackground ? 18 : 0, renderBackground ? 18 : 0);
    }

    public GUIComponentButton(AGUIBase gui, int x, int y, int width, int height) {
        this(gui, x, y, width, height, "", true, ColorRGB.DARK_GRAY, 0, 0, 0, 0);
    }

    public GUIComponentButton(AGUIBase gui, int x, int y, int width, int height, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        this(gui, x, y, width, height, "", true, ColorRGB.DARK_GRAY, textureXOffset, textureYOffset, textureSectionWidth, textureSectionHeight);
    }

    public GUIComponentButton(AGUIBase gui, int x, int y, int width, int height, String text, boolean centeredText, ColorRGB textColor, boolean renderBackground) {
        this(gui, x, y, width, height, text, centeredText, textColor, 0, 196, renderBackground ? 100 : 0, renderBackground ? 20 : 0);
    }

    private GUIComponentButton(AGUIBase gui, int x, int y, int width, int height, String text, boolean centeredText, ColorRGB textColor, int textureXOffset, int textureYOffset, int textureSectionWidth, int textureSectionHeight) {
        super(gui, x, y, width, height, textureXOffset, textureYOffset, textureSectionWidth, textureSectionHeight);
        this.textPosition.set(centeredText ? this.position.x + (double)(width / 2) : this.position.x, this.position.y - (double)((height - 8) / 2), this.textPosition.z);
        this.text = text;
        this.centeredText = centeredText;
        this.textColor = textColor;
        if (textureSectionWidth != 0 && textureSectionHeight != 0) {
            for (int i = 0; i < (this.isDynamicTexture ? 1 : 3); ++i) {
                int textureHeightStart = textureYOffset + i * textureSectionHeight;
                RenderableVertices vertexObject = RenderableVertices.createSprite(3, null, null);
                if (i == 0) {
                    this.setOffsetVertices(gui, textureHeightStart, vertexObject);
                    this.renderable = new RenderableData(vertexObject, gui.getTexture());
                    this.renderableL = new RenderableData(vertexObject, gui.getTexture().replace(".png", "_lit.png"));
                    continue;
                }
                if (i == 1) {
                    this.setOffsetVertices(gui, textureHeightStart, vertexObject);
                    this.renderable2 = new RenderableData(vertexObject, gui.getTexture());
                    this.renderable2L = new RenderableData(vertexObject, gui.getTexture().replace(".png", "_lit.png"));
                    continue;
                }
                this.setOffsetVertices(gui, textureHeightStart, vertexObject);
                this.renderable3 = new RenderableData(vertexObject, gui.getTexture());
                this.renderable3L = new RenderableData(vertexObject, gui.getTexture().replace(".png", "_lit.png"));
            }
        }
    }

    public boolean canClick(int mouseX, int mouseY) {
        return this.visible && this.enabled && this.isMouseInBounds(mouseX, mouseY);
    }

    public abstract void onClicked(boolean var1);

    public void onReleased() {
    }

    @Override
    public void render(AGUIBase gui, int mouseX, int mouseY, boolean renderBright, boolean renderLitTexture, boolean blendingEnabled, float partialTicks) {
        if (this.textureSectionWidth != 0 && this.textureSectionHeight != 0) {
            RenderableData currentRenderable;
            if (this.enabled && !this.isDynamicTexture) {
                currentRenderable = this.isMouseInBounds(mouseX, mouseY) ? (renderLitTexture ? this.renderable3L : this.renderable3) : (renderLitTexture ? this.renderable2L : this.renderable2);
            } else {
                RenderableData renderableData = currentRenderable = renderLitTexture ? this.renderableL : this.renderable;
                if (this.isDynamicTexture) {
                    this.setOffsetVertices(gui, this.textureYOffset, currentRenderable.vertexObject);
                }
            }
            if (currentRenderable.isTranslucent == blendingEnabled) {
                currentRenderable.setTexture(renderLitTexture ? gui.getTexture().replace(".png", "_lit.png") : gui.getTexture());
                currentRenderable.setLightValue(gui.worldLightValue);
                currentRenderable.setLightMode(renderBright || this.ignoreGUILightingState ? RenderableData.LightingMode.IGNORE_ALL_LIGHTING : RenderableData.LightingMode.IGNORE_ORIENTATION_LIGHTING);
                currentRenderable.transform.setTranslation(this.position);
                currentRenderable.render();
            }
        }
    }

    @Override
    public void renderText(boolean renderTextLit, int worldLightValue) {
        RenderText.drawText(this.text, null, this.textPosition, this.textColor, this.centeredText ? RenderText.TextAlignment.CENTERED : RenderText.TextAlignment.LEFT_ALIGNED, 1.0f, false, 0, renderTextLit || this.ignoreGUILightingState, worldLightValue);
    }

    private void setOffsetVertices(AGUIBase gui, int textureHeightStart, RenderableVertices vertexObject) {
        vertexObject.setSpriteProperties(0, 0, 0, 6, this.height, (float)this.textureXOffset / (float)gui.getTextureWidth(), (float)textureHeightStart / (float)gui.getTextureHeight(), (float)(this.textureXOffset + 6) / (float)gui.getTextureWidth(), (float)(textureHeightStart + this.textureSectionHeight) / (float)gui.getTextureHeight());
        vertexObject.setSpriteProperties(1, 6, 0, this.width - 12, this.height, (float)(this.textureXOffset + 6) / (float)gui.getTextureWidth(), (float)textureHeightStart / (float)gui.getTextureHeight(), (float)(this.textureXOffset + this.textureSectionWidth - 6) / (float)gui.getTextureWidth(), (float)(textureHeightStart + this.textureSectionHeight) / (float)gui.getTextureHeight());
        vertexObject.setSpriteProperties(2, this.width - 6, 0, 6, this.height, (float)(this.textureXOffset + this.textureSectionWidth - 6) / (float)gui.getTextureWidth(), (float)textureHeightStart / (float)gui.getTextureHeight(), (float)(this.textureXOffset + this.textureSectionWidth) / (float)gui.getTextureWidth(), (float)(textureHeightStart + this.textureSectionHeight) / (float)gui.getTextureHeight());
    }
}

