/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.items.instances.ItemPartPropeller;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class PartPropeller
extends APart {
    private double currentRPM;
    private double angularPosition;
    private double angularVelocity;
    public int currentPitch;
    public double airstreamLinearVelocity;
    public double desiredLinearVelocity;
    private final List<PartEngine> connectedEngines = new ArrayList<PartEngine>();
    protected final Point3D propellerAxisVector = new Point3D();
    private final Point3D propellerForce = new Point3D();
    private double propellerForceValue;
    private final BoundingBox damageBounds;
    public static final int MIN_DYNAMIC_PITCH = 45;

    public PartPropeller(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartPropeller item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        this.currentPitch = data != null ? data.getInteger("currentPitch") : ((JSONPart)this.definition).propeller.pitch;
        double propellerRadius = (double)((JSONPart)this.definition).propeller.diameter * 0.0254 / 2.0;
        this.damageBounds = ((JSONPart)this.definition).propeller.isRotor ? new BoundingBox(this.position, propellerRadius, 0.25, propellerRadius) : new BoundingBox(this.position, propellerRadius, propellerRadius, propellerRadius);
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater && damage.entityResponsible instanceof IWrapperPlayer && ((IWrapperPlayer)damage.entityResponsible).getHeldStack().isEmpty() && !this.masterEntity.allParts.contains(damage.entityResponsible.getEntityRiding())) {
            this.connectedEngines.forEach(connectedEngine -> {
                connectedEngine.handStartEngine();
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine((PartEngine)connectedEngine, PacketPartEngine.Signal.HS_ON));
            });
        }
    }

    @Override
    public void update() {
        super.update();
        this.currentRPM = 0.0;
        if (this.isActive) {
            boolean increasePitch = false;
            boolean decreasePitch = false;
            if (!this.connectedEngines.isEmpty()) {
                double highestPossibleRPM = 0.0;
                double highestRunningRPM = 0.0;
                PartEngine currentConnectedEngine = null;
                for (PartEngine connectedEngine : this.connectedEngines) {
                    if (connectedEngine.propellerGearboxRatio == 0.0) continue;
                    double engineDrivenRPM = connectedEngine.rpm / connectedEngine.propellerGearboxRatio;
                    if (currentConnectedEngine == null || engineDrivenRPM > highestPossibleRPM) {
                        highestPossibleRPM = engineDrivenRPM;
                        currentConnectedEngine = connectedEngine;
                    }
                    if (!connectedEngine.running || !(engineDrivenRPM > highestRunningRPM)) continue;
                    highestRunningRPM = engineDrivenRPM;
                    currentConnectedEngine = connectedEngine;
                }
                double d = this.currentRPM = highestRunningRPM > 0.0 ? highestRunningRPM : highestPossibleRPM;
                if (currentConnectedEngine != null && ((JSONPart)this.definition).propeller.isDynamicPitch) {
                    if (this.currentPitch > 45) {
                        boolean bl = decreasePitch = currentConnectedEngine.rpm < (double)((JSONPart)currentConnectedEngine.definition).engine.maxSafeRPM * 0.6;
                    }
                    if (this.currentPitch < ((JSONPart)this.definition).propeller.pitch) {
                        boolean bl = increasePitch = currentConnectedEngine.rpm > (double)((JSONPart)currentConnectedEngine.definition).engine.maxSafeRPM * 0.85;
                    }
                }
            }
            if (this.vehicleOn != null) {
                if (((JSONPart)this.definition).propeller.isRotor) {
                    double throttlePitchSetting = (this.vehicleOn.throttleVar.currentValue * 1.35 - 0.35) * (double)((JSONPart)this.definition).propeller.pitch;
                    if (throttlePitchSetting < (double)this.currentPitch) {
                        this.currentPitch -= ((JSONPart)this.definition).propeller.pitchChangeRate;
                    } else if (throttlePitchSetting > (double)this.currentPitch) {
                        this.currentPitch += ((JSONPart)this.definition).propeller.pitchChangeRate;
                    }
                } else if (((JSONPart)this.definition).propeller.isDynamicPitch) {
                    if (decreasePitch || this.vehicleOn.reverseThrustVar.isActive && this.currentPitch > -45) {
                        this.currentPitch -= ((JSONPart)this.definition).propeller.pitchChangeRate;
                    } else if (increasePitch || !this.vehicleOn.reverseThrustVar.isActive && this.currentPitch < 45) {
                        this.currentPitch += ((JSONPart)this.definition).propeller.pitchChangeRate;
                    }
                }
            }
        }
        this.angularVelocity = this.currentRPM != 0.0 ? (double)((float)(this.currentRPM / 60.0 / 20.0)) : (this.angularVelocity > 0.01 ? (this.angularVelocity -= 0.01) : (this.angularVelocity < -0.01 ? (this.angularVelocity += 0.01) : 0.0));
        this.angularPosition += this.angularVelocity;
        if (this.angularPosition > 3600000.0) {
            this.angularPosition -= 3600000.0;
            this.angularPosition -= 3600000.0;
        } else if (this.angularPosition < -3600000.0) {
            this.angularPosition += 3600000.0;
            this.angularPosition += 3600000.0;
        }
        this.airstreamLinearVelocity = 20.0 * this.masterEntity.motion.dotProduct(this.propellerAxisVector, false);
        this.desiredLinearVelocity = 0.0254 * (double)(this.currentPitch + 20) * 20.0 * this.angularVelocity;
        if (!this.world.isClient() && this.currentRPM >= 100.0) {
            this.boundingBox.widthRadius += 0.2;
            this.boundingBox.heightRadius += 0.2;
            this.boundingBox.depthRadius += 0.2;
            IWrapperEntity controller = this.vehicleOn.getController();
            LanguageSystem.LanguageEntry language = controller != null ? LanguageSystem.DEATH_PROPELLER_PLAYER : LanguageSystem.DEATH_PROPELLER_NULL;
            Damage propellerDamage = new Damage((Double)ConfigSystem.settings.damage.propellerDamageFactor.value * this.currentRPM / 500.0, this.damageBounds, this, controller, language);
            this.world.attackEntities(propellerDamage, null, false);
            this.boundingBox.widthRadius -= 0.2;
            this.boundingBox.heightRadius -= 0.2;
            this.boundingBox.depthRadius -= 0.2;
        }
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.connectedEngines.clear();
        if (this.entityOn instanceof PartEngine) {
            this.connectedEngines.add((PartEngine)this.entityOn);
        }
        this.addLinkedPartsToList(this.connectedEngines, PartEngine.class);
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "propeller_pitch_deg": {
                return new ComputedVariable(this, variable, partialTicks -> Math.toDegrees(Math.atan((double)this.currentPitch / ((double)((JSONPart)this.definition).propeller.diameter * 0.75 * Math.PI))), false);
            }
            case "propeller_pitch_in": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentPitch, false);
            }
            case "propeller_pitch_percent": {
                return new ComputedVariable(this, variable, partialTicks -> 1.0 * (double)(this.currentPitch - 45) / (double)(((JSONPart)this.definition).propeller.pitch - 45), false);
            }
            case "propeller_rotation": {
                return new ComputedVariable(this, variable, partialTicks -> (partialTicks != 0.0f ? this.angularPosition - this.angularVelocity * (double)(1.0f - partialTicks) : this.angularPosition) * 360.0, true);
            }
            case "propeller_rpm": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentRPM, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    public double addToForceOutput(Point3D force, Point3D torque) {
        this.propellerForceValue = 0.0;
        this.propellerAxisVector.set(0.0, 0.0, 1.0).rotate(this.orientation);
        if (this.currentRPM != 0.0 && this.desiredLinearVelocity != 0.0) {
            double thrust = this.desiredLinearVelocity - this.airstreamLinearVelocity;
            thrust *= Math.PI * Math.pow(0.0254 * (double)((JSONPart)this.definition).propeller.diameter / 2.0, 2.0);
            thrust *= this.vehicleOn.airDensity / 25.0 * 1.5;
            double angleOfAttack = (this.desiredLinearVelocity - this.airstreamLinearVelocity) / (this.currentRPM / 60.0) / ((double)((JSONPart)this.definition).propeller.diameter * Math.PI * 0.0254);
            if (Math.abs(angleOfAttack) > 0.4663) {
                thrust *= 0.4663 / Math.abs(angleOfAttack);
            }
            if (this.isInLiquid() && !((JSONPart)this.definition).propeller.isRotor) {
                thrust *= 50.0;
            }
            this.propellerForceValue += thrust;
            this.propellerForce.set(this.propellerAxisVector).scale(thrust);
            force.add(this.propellerForce);
            this.propellerForce.reOrigin(this.vehicleOn.orientation);
            if (this.partOn != null && ((JSONPart)this.partOn.definition).engine.allowThrustVector) {
                torque.add(this.localOffset.crossProduct(this.propellerForce));
            } else {
                torque.y -= this.propellerForce.z * this.localOffset.x;
                torque.z += this.propellerForce.y * this.localOffset.x;
            }
        }
        return this.propellerForceValue;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("currentPitch", this.currentPitch);
        return data;
    }
}

