/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.entities.instances.AEntityCrafter;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;

public class EntityFurnace
extends AEntityCrafter {
    private static final int SMELTING_ITEM_SLOT = 1;
    private static final int SMELTED_ITEM_SLOT = 2;
    public static final String FURNACE_FUEL_NAME = "furnace";

    public EntityFurnace(AWrapperWorld world, IWrapperNBT data, JSONPart.JSONPartInteractable definition) {
        super(world, data, 3, definition, new int[]{1}, new int[]{2});
    }

    @Override
    protected IWrapperItemStack getResultForSlot(int index) {
        IWrapperItemStack smeltingStack = this.getStack(1);
        if (!smeltingStack.isEmpty()) {
            IWrapperItemStack smeltingResult = smeltingStack.getSmeltedItem(this.world);
            IWrapperItemStack stackInResult = this.getStack(2);
            if (stackInResult.isEmpty() || stackInResult.isCompleteMatch(smeltingResult) && stackInResult.getMaxSize() - stackInResult.getSize() >= smeltingResult.getSize()) {
                return smeltingResult;
            }
        }
        return EMPTY_STACK;
    }

    @Override
    public String getFuelName() {
        return FURNACE_FUEL_NAME;
    }

    @Override
    protected int getFuelTime(IWrapperItemStack stack) {
        return stack.getFurnaceFuelValue();
    }

    @Override
    protected int getTimeForItem(IWrapperItemStack stack) {
        return stack.getSmeltingTime(this.world);
    }

    @Override
    public boolean isStackValid(IWrapperItemStack stackToCheck, int index) {
        if (index == 1) {
            return !stackToCheck.getSmeltedItem(this.world).isEmpty();
        }
        return super.isStackValid(stackToCheck, index);
    }
}

