/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.instances.ATileEntityFuelPump;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.items.instances.ItemPartInteractable;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONText;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.LanguageSystem;

public class TileEntityFuelPump
extends ATileEntityFuelPump
implements ITileEntityFluidTankProvider {
    private final EntityFluidTank tank;

    public TileEntityFuelPump(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.tank = new EntityFluidTank(world, data != null ? data.getData("tank") : null, ((JSONDecor)this.definition).decor.fuelCapacity){

            @Override
            public double fill(String fluid, String fluidMod, double maxAmount, boolean doFill) {
                double amountPurchasedRemaining;
                if (!TileEntityFuelPump.this.isCreative && !this.world.isClient() && maxAmount > (amountPurchasedRemaining = (double)TileEntityFuelPump.this.fuelPurchased - TileEntityFuelPump.this.fuelDispensedThisPurchase - this.getFluidLevel())) {
                    maxAmount = amountPurchasedRemaining;
                }
                return super.fill(fluid, fluidMod, maxAmount, doFill);
            }
        };
        world.addEntity(this.tank);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (player.getHeldStack().interactWith(this.tank, player)) {
            return true;
        }
        IWrapperItemStack stack = player.getHeldStack();
        AItemBase item = stack.getItem();
        if (item instanceof ItemPartInteractable) {
            ItemPartInteractable interactable = (ItemPartInteractable)item;
            if (((JSONPart)interactable.definition).interactable.interactionType.equals((Object)JSONPart.InteractableComponentType.JERRYCAN)) {
                if (this.tank.getFluidLevel() >= 1000.0) {
                    IWrapperNBT data = stack.getData();
                    if (data == null) {
                        data = InterfaceManager.coreInterface.getNewNBTWrapper();
                    }
                    if (data.getString("jerrycanFluid").isEmpty()) {
                        data.setString("jerrycanFluid", this.tank.getFluid());
                        stack.setData(data);
                        this.tank.drain(1000.0, true);
                    }
                }
                return true;
            }
        }
        return super.interact(player);
    }

    @Override
    public IWrapperItemStack getStack() {
        IWrapperItemStack stack = super.getStack();
        IWrapperNBT data = stack.getData();
        data.setData("tank", this.tank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        stack.setData(data);
        return stack;
    }

    @Override
    public void remove() {
        super.remove();
        this.tank.remove();
    }

    @Override
    protected boolean hasFuel() {
        return this.tank.getFluidLevel() > 0.0;
    }

    @Override
    protected AEntityVehicleE_Powered.FuelTankResult checkPump(EntityVehicleF_Physics vehicle) {
        return vehicle.checkFuelTankCompatibility(this.tank.getFluid());
    }

    @Override
    public double fuelVehicle(double amount) {
        if (amount > 0.0 && this.tank.getFluidLevel() > 0.0) {
            double amountToFill = this.connectedVehicle.fuelTank.fill(this.tank.getFluid(), "wildcard", amount, false);
            if (amountToFill > 0.0) {
                String fluid = this.tank.getFluid();
                double amountToDrain = this.tank.drain(amountToFill, true);
                this.connectedVehicle.fuelTank.fill(fluid, "wildcard", amountToDrain, true);
                return amountToDrain;
            }
        } else {
            this.playerUsing.sendPacket(new PacketPlayerChatMessage(this.playerUsing, LanguageSystem.INTERACT_FUELPUMP_EMPTY, new Object[0]));
            this.setConnection(null);
        }
        return 0.0;
    }

    @Override
    public EntityFluidTank getTank() {
        return this.tank;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "fuelpump_active": {
                return new ComputedVariable(this, variable, partialTicks -> this.connectedVehicle != null ? 1.0 : 0.0, false);
            }
            case "fuelpump_dispensed": {
                return new ComputedVariable(this, variable, partialTicks -> this.fuelDispensedThisConnection, false);
            }
            case "fuelpump_free": {
                return new ComputedVariable(this, variable, partialTicks -> this.isCreative ? 1.0 : 0.0, false);
            }
            case "fuelpump_purchased": {
                return new ComputedVariable(this, variable, partialTicks -> this.fuelPurchased, false);
            }
            case "fuelpump_stored": {
                return new ComputedVariable(this, variable, partialTicks -> this.tank.getFluidLevel(), false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public String getRawTextVariableValue(JSONText textDef, float partialTicks) {
        if (textDef.variableName.equals("fuelpump_fluid")) {
            return this.tank.getFluidLevel() > 0.0 ? InterfaceManager.clientInterface.getFluidName(this.tank.getFluid(), this.tank.getFluidMod()) : "";
        }
        return super.getRawTextVariableValue(textDef, partialTicks);
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setData("tank", this.tank.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        return data;
    }
}

