/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201.mixin.client;

import mcinterface1201.WrapperEntity;
import mcinterface1201.WrapperPlayer;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity> {
    private static final float yArmAngleRad = (float)Math.toRadians(10.0);

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    public void inject_setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (((Boolean)ConfigSystem.client.renderingSettings.playerTweaks.value).booleanValue()) {
            EntityPlayerGun gunEntity;
            HumanoidModel model = (HumanoidModel)this;
            WrapperEntity entityWrapper = WrapperEntity.getWrapperFor(entity);
            AEntityB_Existing ridingEntity = entityWrapper.getEntityRiding();
            if (ridingEntity != null) {
                boolean renderCurrentRiderStanding = false;
                if (ridingEntity instanceof PartSeat) {
                    PartSeat seat = (PartSeat)ridingEntity;
                    renderCurrentRiderStanding = ((JSONPart)seat.definition).seat.standing;
                    if (seat.vehicleOn != null && seat.placementDefinition.isController) {
                        double turningAngle = seat.vehicleOn.rudderInputVar.currentValue / 2.0;
                        model.f_102811_.f_104203_ = (float)Math.toRadians(-75.0 + turningAngle);
                        model.f_102811_.f_104204_ = -yArmAngleRad;
                        model.f_102811_.f_104205_ = 0.0f;
                        model.f_102812_.f_104203_ = (float)Math.toRadians(-75.0 - turningAngle);
                        model.f_102812_.f_104204_ = yArmAngleRad;
                        model.f_102812_.f_104205_ = 0.0f;
                    }
                }
                if (renderCurrentRiderStanding) {
                    model.f_102814_.f_104203_ = 0.0f;
                    model.f_102814_.f_104204_ = 0.0f;
                    model.f_102814_.f_104205_ = 0.0f;
                    model.f_102813_.f_104203_ = 0.0f;
                    model.f_102813_.f_104204_ = 0.0f;
                    model.f_102813_.f_104205_ = 0.0f;
                } else {
                    model.f_102814_.f_104203_ = (float)Math.toRadians(-90.0);
                    model.f_102814_.f_104204_ = 0.0f;
                    model.f_102814_.f_104205_ = 0.0f;
                    model.f_102813_.f_104203_ = (float)Math.toRadians(-90.0);
                    model.f_102813_.f_104204_ = 0.0f;
                    model.f_102813_.f_104205_ = 0.0f;
                }
            }
            if (entity instanceof Player && (gunEntity = EntityPlayerGun.playerClientGuns.get(entity.m_20148_())) != null && gunEntity.activeGun != null) {
                Point3D heldVector = gunEntity.activeGun.isHandHeldGunAimed ? ((JSONPart)gunEntity.activeGun.definition).gun.handHeldAimedOffset : ((JSONPart)gunEntity.activeGun.definition).gun.handHeldNormalOffset;
                double heldVectorLength = heldVector.length();
                double armPitchOffset = Math.toRadians(-90.0f + entity.m_146909_()) - Math.asin(heldVector.y / heldVectorLength);
                double armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                WrapperPlayer playerWrapper = WrapperPlayer.getWrapperFor((Player)entity);
                if (playerWrapper.isRightHanded()) {
                    model.f_102811_.f_104203_ = (float)armPitchOffset;
                    model.f_102811_.f_104204_ = (float)(armYawOffset + Math.toRadians(((LivingEntity)entity).f_20885_ - ((LivingEntity)entity).f_20883_));
                    model.f_102811_.f_104205_ = 0.0f;
                } else {
                    model.f_102812_.f_104203_ = (float)armPitchOffset;
                    model.f_102812_.f_104204_ = (float)(-armYawOffset + Math.toRadians(((LivingEntity)entity).f_20885_ - ((LivingEntity)entity).f_20883_));
                    model.f_102812_.f_104205_ = 0.0f;
                }
                if (gunEntity.activeGun.isHandHeldGunAimed || gunEntity.activeGun.twoHandedVar.isActive) {
                    heldVector = heldVector.copy();
                    heldVector.x = 0.625 - heldVector.x;
                    heldVectorLength = heldVector.length();
                    armPitchOffset = Math.toRadians(-90.0f + entity.m_146909_()) - Math.asin(heldVector.y / heldVectorLength);
                    armYawOffset = -Math.atan2(heldVector.x / heldVectorLength, heldVector.z / heldVectorLength);
                    if (playerWrapper.isRightHanded()) {
                        model.f_102812_.f_104203_ = (float)armPitchOffset;
                        model.f_102812_.f_104204_ = (float)(-armYawOffset + Math.toRadians(((LivingEntity)entity).f_20885_ - ((LivingEntity)entity).f_20883_));
                        model.f_102812_.f_104205_ = 0.0f;
                    } else {
                        model.f_102811_.f_104203_ = (float)armPitchOffset;
                        model.f_102811_.f_104204_ = (float)(armYawOffset + Math.toRadians(((LivingEntity)entity).f_20885_ - ((LivingEntity)entity).f_20883_));
                        model.f_102811_.f_104205_ = 0.0f;
                    }
                }
            }
        }
    }
}

