/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.List;
import mcinterface1201.IBuilderItemInterface;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.entities.instances.EntityFluidTank;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;

public class WrapperItemStack
implements IWrapperItemStack {
    protected final ItemStack stack;

    protected WrapperItemStack(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public boolean isCompleteMatch(IWrapperItemStack other) {
        ItemStack otherStack = ((WrapperItemStack)other).stack;
        return !this.stack.m_41619_() && otherStack.m_150930_(this.stack.m_41720_()) && (otherStack.m_41782_() ? otherStack.m_41783_().equals((Object)this.stack.m_41783_()) : !this.stack.m_41782_());
    }

    @Override
    public int getFurnaceFuelValue() {
        return ForgeHooks.getBurnTime((ItemStack)this.stack, null);
    }

    @Override
    public IWrapperItemStack getSmeltedItem(AWrapperWorld world) {
        Level mcWorld = ((WrapperWorld)world).world;
        List results = mcWorld.m_7465_().m_44013_(RecipeType.f_44108_);
        return new WrapperItemStack(results.isEmpty() ? ItemStack.f_41583_ : ((SmeltingRecipe)results.get(0)).m_8043_(((WrapperWorld)world).world.m_9598_()));
    }

    @Override
    public int getSmeltingTime(AWrapperWorld world) {
        Level mcWorld = ((WrapperWorld)world).world;
        return ((SmeltingRecipe)mcWorld.m_7465_().m_44013_(RecipeType.f_44108_).get(0)).m_43753_();
    }

    @Override
    public boolean isBrewingFuel() {
        return this.stack.m_41720_() == Items.f_42593_;
    }

    @Override
    public boolean isBrewingVessel() {
        return BrewingRecipeRegistry.isValidInput((ItemStack)this.stack);
    }

    @Override
    public boolean isBrewingModifier() {
        return BrewingRecipeRegistry.isValidIngredient((ItemStack)this.stack);
    }

    @Override
    public IWrapperItemStack getBrewedItem(IWrapperItemStack modifierStack) {
        return new WrapperItemStack(BrewingRecipeRegistry.getOutput((ItemStack)this.stack, (ItemStack)((WrapperItemStack)modifierStack).stack).m_41777_());
    }

    @Override
    public AItemBase getItem() {
        Item item = this.stack.m_41720_();
        return item instanceof IBuilderItemInterface ? ((IBuilderItemInterface)item).getWrappedItem() : null;
    }

    @Override
    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    @Override
    public int getSize() {
        return this.stack.m_41613_();
    }

    @Override
    public int getMaxSize() {
        return this.stack.m_41741_();
    }

    @Override
    public int add(int qty) {
        if (qty < 0) {
            int amountToRemove = -qty;
            if (amountToRemove > this.getSize()) {
                amountToRemove = this.getSize();
            }
            this.stack.m_41764_(this.stack.m_41613_() - amountToRemove);
            return qty + amountToRemove;
        }
        int amountToAdd = qty;
        if (amountToAdd + this.getSize() > this.getMaxSize()) {
            amountToAdd = this.getMaxSize() - this.getSize();
        }
        this.stack.m_41764_(this.stack.m_41613_() + amountToAdd);
        return qty - amountToAdd;
    }

    @Override
    public IWrapperItemStack copy() {
        return new WrapperItemStack(this.stack.m_41777_());
    }

    @Override
    public IWrapperItemStack split(int qty) {
        return new WrapperItemStack(this.stack.m_41620_(qty));
    }

    @Override
    public boolean interactWith(EntityFluidTank tank, IWrapperPlayer player) {
        IFluidHandlerItem handler = (IFluidHandlerItem)this.stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null);
        if (handler != null) {
            if (!player.isSneaking()) {
                ResourceLocation fluidLocation;
                int amountToDrain;
                FluidStack drainedStack = handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                if (drainedStack != null && (drainedStack = handler.drain(amountToDrain = (int)tank.fill((fluidLocation = ForgeRegistries.FLUIDS.getKey((Object)drainedStack.getFluid())).m_135815_(), fluidLocation.m_135827_(), drainedStack.getAmount(), false), player.isCreative() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)) != null) {
                    tank.fill(fluidLocation.m_135815_(), fluidLocation.m_135827_(), drainedStack.getAmount(), true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            } else {
                for (ResourceLocation fluidKey : ForgeRegistries.FLUIDS.getKeys()) {
                    FluidStack containedStack;
                    int amountFilled;
                    if (!tank.getFluidMod().equals("wildcard") && !tank.getFluidMod().equals(fluidKey.m_135827_()) || !fluidKey.m_135815_().equals(tank.getFluid()) || (amountFilled = handler.fill(containedStack = new FluidStack((Fluid)ForgeRegistries.FLUIDS.getValue(fluidKey), (int)tank.getFluidLevel()), player.isCreative() ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                    tank.drain(amountFilled, true);
                    player.setHeldStack(new WrapperItemStack(handler.getContainer()));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IWrapperNBT getData() {
        return this.stack.m_41782_() ? new WrapperNBT(this.stack.m_41783_().m_6426_()) : null;
    }

    @Override
    public void setData(IWrapperNBT data) {
        this.stack.m_41751_(data != null ? ((WrapperNBT)data).tag : null);
    }
}

