/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WrapperAABBCollective
extends AABB {
    private final AEntityE_Interactable<?> interactable;
    private final boolean collision;
    private final Set<BoundingBox> boxes = new HashSet<BoundingBox>();

    public WrapperAABBCollective(AEntityE_Interactable<?> interactable, boolean collision) {
        super(interactable.encompassingBox.globalCenter.x - interactable.encompassingBox.widthRadius, interactable.encompassingBox.globalCenter.y - interactable.encompassingBox.heightRadius, interactable.encompassingBox.globalCenter.z - interactable.encompassingBox.depthRadius, interactable.encompassingBox.globalCenter.x + interactable.encompassingBox.widthRadius, interactable.encompassingBox.globalCenter.y + interactable.encompassingBox.heightRadius, interactable.encompassingBox.globalCenter.z + interactable.encompassingBox.depthRadius);
        this.interactable = interactable;
        this.collision = collision;
    }

    public synchronized Set<BoundingBox> getBoxes() {
        if (this.boxes.isEmpty()) {
            (this.interactable instanceof AEntityF_Multipart ? ((AEntityF_Multipart)this.interactable).allCollisionBoxes : this.interactable.collisionBoxes).forEach(box -> {
                if (this.collision) {
                    if (box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ENTITY)) {
                        this.boxes.add((BoundingBox)box);
                    }
                } else if (box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ATTACK) || box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.CLICK)) {
                    this.boxes.add((BoundingBox)box);
                }
            });
        }
        return this.boxes;
    }

    public WrapperAABBCollective inflate(double value) {
        return this;
    }

    public boolean m_82314_(double otherMinX, double otherMinY, double otherMinZ, double otherMaxX, double otherMaxY, double otherMaxZ) {
        if (super.m_82314_(otherMinX, otherMinY, otherMinZ, otherMaxX, otherMaxY, otherMaxZ)) {
            for (BoundingBox testBox : this.getBoxes()) {
                if (!(otherMaxX > testBox.globalCenter.x - testBox.widthRadius) || !(otherMinX < testBox.globalCenter.x + testBox.widthRadius) || !(otherMaxY > testBox.globalCenter.y - testBox.heightRadius) || !(otherMinY < testBox.globalCenter.y + testBox.heightRadius) || !(otherMaxZ > testBox.globalCenter.z - testBox.depthRadius) || !(otherMinZ < testBox.globalCenter.z + testBox.depthRadius)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_82390_(Vec3 vec) {
        return this.m_82314_(vec.f_82479_, vec.f_82480_, vec.f_82481_, vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public Optional<Vec3> m_82371_(Vec3 vecA, Vec3 vecB) {
        Point3D start = new Point3D(vecA.f_82479_, vecA.f_82480_, vecA.f_82481_);
        Point3D end = new Point3D(vecB.f_82479_, vecB.f_82480_, vecB.f_82481_);
        BoundingBoxHitResult intersection = null;
        for (BoundingBox testBox : this.getBoxes()) {
            BoundingBoxHitResult testIntersection = testBox.getIntersection(start, end);
            if (testIntersection == null || intersection != null && !start.isFirstCloserThanSecond(testIntersection.position, intersection.position)) continue;
            intersection = testIntersection;
        }
        if (intersection != null) {
            return Optional.of(new Vec3(intersection.position.x, intersection.position.y, intersection.position.z));
        }
        return Optional.empty();
    }

    public Vec3 getCollision(Vec3 movement, AABB testBox) {
        double x = movement.f_82479_ != 0.0 ? this.calculateXOffset(testBox, movement.f_82479_) : 0.0;
        double y = movement.f_82480_ != 0.0 ? this.calculateYOffset(testBox, movement.f_82480_) : 0.0;
        double z = movement.f_82481_ != 0.0 ? this.calculateZOffset(testBox, movement.f_82481_) : 0.0;
        return new Vec3(x, y, z);
    }

    private double calculateXOffset(AABB box, double offset) {
        for (BoundingBox testBox : this.getBoxes()) {
            double collisionDepth;
            if (!(box.f_82292_ > testBox.globalCenter.y - testBox.heightRadius) || !(box.f_82289_ < testBox.globalCenter.y + testBox.heightRadius) || !(box.f_82293_ > testBox.globalCenter.z - testBox.depthRadius) || !(box.f_82290_ < testBox.globalCenter.z + testBox.depthRadius)) continue;
            if (offset > 0.0) {
                collisionDepth = testBox.globalCenter.x - testBox.widthRadius - box.f_82291_;
                if (!(collisionDepth >= 0.0) || !(collisionDepth < offset)) continue;
                offset = collisionDepth;
                continue;
            }
            if (!(offset < 0.0) || !((collisionDepth = testBox.globalCenter.x + testBox.widthRadius - box.f_82288_) <= 0.0) || !(collisionDepth > offset)) continue;
            offset = collisionDepth;
        }
        return offset;
    }

    private double calculateYOffset(AABB box, double offset) {
        for (BoundingBox testBox : this.getBoxes()) {
            double collisionDepth;
            if (!(box.f_82291_ > testBox.globalCenter.x - testBox.widthRadius) || !(box.f_82288_ < testBox.globalCenter.x + testBox.widthRadius) || !(box.f_82293_ > testBox.globalCenter.z - testBox.depthRadius) || !(box.f_82290_ < testBox.globalCenter.z + testBox.depthRadius)) continue;
            if (offset > 0.0) {
                collisionDepth = testBox.globalCenter.y - testBox.heightRadius - box.f_82292_;
                if (!(collisionDepth >= 0.0) || !(collisionDepth < offset)) continue;
                offset = collisionDepth;
                continue;
            }
            if (!(offset < 0.0) || !((collisionDepth = testBox.globalCenter.y + testBox.heightRadius - box.f_82289_) <= 0.0) || !(collisionDepth > offset)) continue;
            offset = collisionDepth;
        }
        return offset;
    }

    private double calculateZOffset(AABB box, double offset) {
        for (BoundingBox testBox : this.getBoxes()) {
            double collisionDepth;
            if (!(box.f_82291_ > testBox.globalCenter.x - testBox.widthRadius) || !(box.f_82288_ < testBox.globalCenter.x + testBox.widthRadius) || !(box.f_82292_ > testBox.globalCenter.y - testBox.heightRadius) || !(box.f_82289_ < testBox.globalCenter.y + testBox.heightRadius)) continue;
            if (offset > 0.0) {
                collisionDepth = testBox.globalCenter.z - testBox.depthRadius - box.f_82293_;
                if (!(collisionDepth >= 0.0) || !(collisionDepth < offset)) continue;
                offset = collisionDepth;
                continue;
            }
            if (!(offset < 0.0) || !((collisionDepth = testBox.globalCenter.z + testBox.depthRadius - box.f_82290_) <= 0.0) || !(collisionDepth > offset)) continue;
            offset = collisionDepth;
        }
        return offset;
    }
}

