/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.ArrayList;
import java.util.List;
import mcinterface1201.WrapperItemStack;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.AJSONItem;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.packloading.PackParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class InterfaceJEI
implements IModPlugin {
    private static final List<BenchRecipeCategory> benchCategories = new ArrayList<BenchRecipeCategory>();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("mts", "main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        benchCategories.clear();
        for (AItemPack<?> packItem : PackParser.getAllPackItems()) {
            if (!(packItem instanceof ItemDecor)) continue;
            ItemDecor benchItem = (ItemDecor)packItem;
            if (((JSONDecor)benchItem.definition).decor.crafting == null) continue;
            ArrayList<PackRecipeWrapper> benchRecipes = new ArrayList<PackRecipeWrapper>();
            for (AItemPack<?> packItemToTest : PackParser.getAllPackItems()) {
                int i;
                if (!packItemToTest.isBenchValid(((JSONDecor)benchItem.definition).decor.crafting)) continue;
                for (i = 0; i < ((AJSONItem)packItemToTest.definition).general.materialLists.size(); ++i) {
                    benchRecipes.add(new PackRecipeWrapper(packItemToTest, i, false));
                }
                if (((AJSONItem)packItemToTest.definition).general.repairMaterialLists == null) continue;
                for (i = 0; i < ((AJSONItem)packItemToTest.definition).general.repairMaterialLists.size(); ++i) {
                    benchRecipes.add(new PackRecipeWrapper(packItemToTest, i, true));
                }
            }
            benchCategories.add(new BenchRecipeCategory(benchItem, benchRecipes, registry.getJeiHelpers().getGuiHelper()));
        }
        registry.addRecipeCategories(benchCategories.toArray(new IRecipeCategory[benchCategories.size()]));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (BenchRecipeCategory benchCategory : benchCategories) {
            registration.addRecipes(benchCategory.getRecipeType(), benchCategory.benchRecipes);
        }
    }

    private static class PackRecipeWrapper {
        private final AItemPack<?> packItem;
        private final int recipeIndex;
        private final boolean forRepair;

        private PackRecipeWrapper(AItemPack<?> packItem, int recipeIndex, boolean forRepair) {
            this.packItem = packItem;
            this.recipeIndex = recipeIndex;
            this.forRepair = forRepair;
        }
    }

    private static class BenchRecipeCategory
    implements IRecipeCategory<PackRecipeWrapper> {
        private final ItemDecor benchItem;
        private final List<PackRecipeWrapper> benchRecipes;
        private final IDrawable background;
        private final IDrawable icon;

        private BenchRecipeCategory(ItemDecor benchItem, List<PackRecipeWrapper> benchRecipes, IGuiHelper guiHelper) {
            this.benchItem = benchItem;
            this.benchRecipes = benchRecipes;
            this.background = guiHelper.createDrawable(new ResourceLocation("mts", "textures/guis/jei_crafting.png"), 0, 0, 134, 97);
            this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((WrapperItemStack)benchItem.getNewStack(null)).stack);
        }

        public RecipeType<PackRecipeWrapper> getRecipeType() {
            return RecipeType.create((String)"mts", (String)this.benchItem.getRegistrationName(), PackRecipeWrapper.class);
        }

        public Component getTitle() {
            return Component.m_237113_((String)this.benchItem.getItemName());
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(IRecipeLayoutBuilder builder, PackRecipeWrapper recipe, IFocusGroup focuse) {
            int numCols = 7;
            List<PackMaterialComponent> components = PackMaterialComponent.parseFromJSON(recipe.packItem, recipe.recipeIndex, true, true, recipe.forRepair, true);
            if (components != null) {
                int itemCount = 0;
                for (PackMaterialComponent component : components) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (IWrapperItemStack stack : component.possibleItems) {
                        stacks.add(((WrapperItemStack)stack).stack);
                    }
                    int xOffset = 6 + 17 * (itemCount % 7);
                    int yOffset = 6 + 17 * (itemCount / 7);
                    builder.addSlot(RecipeIngredientRole.INPUT, xOffset, yOffset).addItemStacks(stacks);
                    ++itemCount;
                }
                builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 71).addItemStack(((WrapperItemStack)recipe.packItem.getNewStack(null)).stack);
            }
        }
    }
}

