/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.EntityManager;
import minecrafttransportsimulator.guis.instances.GUIConfig;
import minecrafttransportsimulator.jsondefs.JSONConfigClient;
import minecrafttransportsimulator.mcinterface.IInterfaceInput;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.JSONParser;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.LanguageSystem;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InterfaceInput
implements IInterfaceInput {
    private static KeyMapping configKey;
    private static KeyMapping importKey;
    private static int lastScrollValue;
    private static boolean runningJoystickThread;
    private static boolean joystickEnabled;
    private static boolean joystickBlocked;
    private static final Map<String, Integer> joystickNameCounters;
    private static final Map<String, Integer> joystickMap;
    private static final Map<String, Integer> joystickAxisCounts;
    private static final Map<String, Integer> joystickHatCounts;
    private static final Map<String, Integer> joystickButtonCounts;
    private static final Map<String, Integer> joystickComponentCounts;

    @Override
    public int getKeysetID() {
        return 16;
    }

    @Override
    public void initConfigKey() {
        configKey = new KeyMapping(LanguageSystem.GUI_MASTERCONFIG.getCurrentValue(), 80, "Immersive Vehicles (MTS)");
        importKey = new KeyMapping(LanguageSystem.GUI_IMPORT.getCurrentValue(), -1, "Immersive Vehicles (MTS)");
    }

    public static void onIVRegisterKeyMappingsEvent(RegisterKeyMappingsEvent event) {
        event.register(configKey);
        event.register(importKey);
    }

    @Override
    public void initJoysticks() {
        if (!runningJoystickThread) {
            runningJoystickThread = true;
            joystickBlocked = true;
            Thread joystickThread = new Thread(() -> {
                try {
                    joystickNameCounters.clear();
                    joystickMap.clear();
                    joystickAxisCounts.clear();
                    joystickHatCounts.clear();
                    joystickButtonCounts.clear();
                    joystickComponentCounts.clear();
                    for (int i = 0; i < 15; ++i) {
                        joystickEnabled = true;
                        if (GLFW.glfwGetJoystickName((int)i) == null || GLFW.glfwGetJoystickAxes((int)i).limit() <= 0 || GLFW.glfwGetJoystickButtons((int)i).limit() <= 0) continue;
                        String joystickName = GLFW.glfwGetJoystickName((int)i);
                        if (!joystickNameCounters.containsKey(joystickName)) {
                            joystickNameCounters.put(joystickName, 0);
                        }
                        String joystickID = joystickName + "_" + String.valueOf(joystickNameCounters.get(joystickName));
                        joystickMap.put(joystickID, i);
                        joystickNameCounters.put(joystickName, joystickNameCounters.get(joystickName) + 1);
                        joystickAxisCounts.put(joystickID, GLFW.glfwGetJoystickAxes((int)i).limit());
                        joystickHatCounts.put(joystickID, GLFW.glfwGetJoystickHats((int)i) == null ? 0 : GLFW.glfwGetJoystickHats((int)i).limit());
                        joystickButtonCounts.put(joystickID, GLFW.glfwGetJoystickButtons((int)i).limit());
                        joystickComponentCounts.put(joystickID, joystickAxisCounts.get(joystickID) + joystickHatCounts.get(joystickID) + joystickButtonCounts.get(joystickID));
                    }
                    Iterator<Map.Entry<String, JSONConfigClient.ConfigJoystick>> iterator = ConfigSystem.client.controls.joystick.entrySet().iterator();
                    while (iterator.hasNext()) {
                        try {
                            Map.Entry<String, JSONConfigClient.ConfigJoystick> controllerEntry = iterator.next();
                            ControlSystem.ControlsJoystick control = ControlSystem.ControlsJoystick.valueOf(controllerEntry.getKey().toUpperCase(Locale.ROOT));
                            JSONConfigClient.ConfigJoystick config = controllerEntry.getValue();
                            if (!joystickMap.containsKey(config.joystickName)) continue;
                            if (control.isAxis) {
                                if (joystickAxisCounts.get(config.joystickName) > config.buttonIndex) continue;
                                iterator.remove();
                                InterfaceManager.coreInterface.logError("Removed joystick with too low axis count.  Had " + String.valueOf(joystickAxisCounts.get(config.joystickName)) + " requested " + config.buttonIndex);
                                continue;
                            }
                            if (joystickComponentCounts.get(config.joystickName) > config.buttonIndex) continue;
                            iterator.remove();
                            InterfaceManager.coreInterface.logError("Removed joystick with too low button count.  Had " + String.valueOf(joystickComponentCounts.get(config.joystickName)) + " requested " + config.buttonIndex);
                        }
                        catch (Exception e) {
                            iterator.remove();
                        }
                    }
                    joystickBlocked = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    InterfaceManager.coreInterface.logError(e.getMessage());
                    for (StackTraceElement s : e.getStackTrace()) {
                        InterfaceManager.coreInterface.logError(s.toString());
                    }
                }
                runningJoystickThread = false;
            });
            joystickThread.start();
        }
    }

    @Override
    public String getNameForKeyCode(int keyCode) {
        return InputConstants.m_84827_((int)keyCode, (int)0).m_84875_().getString();
    }

    @Override
    public int getKeyCodeForName(String name) {
        switch (name) {
            case "RSHIFT": {
                return InputConstants.m_84851_((String)"key.keyboard.right.shift").m_84873_();
            }
            case "PRIOR": {
                return InputConstants.m_84851_((String)"key.keyboard.page.up").m_84873_();
            }
            case "NEXT": {
                return InputConstants.m_84851_((String)"key.keyboard.page.down").m_84873_();
            }
            case "SCROLL": {
                return InputConstants.m_84851_((String)"key.keyboard.scroll.lock").m_84873_();
            }
        }
        if (name.contains("NUMPAD")) {
            return InputConstants.m_84851_((String)("key.keyboard.keypad." + name.substring(name.length() - 1))).m_84873_();
        }
        return InputConstants.m_84851_((String)("key.keyboard." + name.toLowerCase(Locale.ROOT))).m_84873_();
    }

    @Override
    public boolean isKeyPressed(int keyCode) {
        return GLFW.glfwGetKey((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keyCode) == 1;
    }

    @Override
    public void setGUIControls(boolean enabled) {
    }

    @Override
    public boolean isJoystickSupportEnabled() {
        return joystickEnabled;
    }

    @Override
    public boolean isJoystickSupportBlocked() {
        return joystickBlocked;
    }

    @Override
    public boolean isJoystickPresent(String joystickName) {
        return joystickMap.containsKey(joystickName);
    }

    @Override
    public List<String> getAllJoystickNames() {
        return new ArrayList<String>(joystickMap.keySet());
    }

    @Override
    public int getJoystickComponentCount(String joystickName) {
        return joystickComponentCounts.get(joystickName);
    }

    @Override
    public String getJoystickComponentName(String joystickName, int index) {
        if (this.isJoystickComponentAxis(joystickName, index)) {
            return "Axis: " + String.valueOf(index);
        }
        if (index < joystickAxisCounts.get(joystickName) + joystickHatCounts.get(joystickName)) {
            return "Hat: " + String.valueOf(index - joystickAxisCounts.get(joystickName));
        }
        return "Button: " + String.valueOf(index - joystickAxisCounts.get(joystickName) - joystickHatCounts.get(joystickName));
    }

    @Override
    public boolean isJoystickComponentAxis(String joystickName, int index) {
        return GLFW.glfwGetJoystickAxes((int)joystickMap.get(joystickName)).limit() > index;
    }

    @Override
    public float getJoystickAxisValue(String joystickName, int index) {
        if (joystickMap.containsKey(joystickName)) {
            if (this.isJoystickComponentAxis(joystickName, index)) {
                return GLFW.glfwGetJoystickAxes((int)joystickMap.get(joystickName)).get(index);
            }
            if (index < joystickAxisCounts.get(joystickName) + joystickHatCounts.get(joystickName)) {
                switch (GLFW.glfwGetJoystickHats((int)joystickMap.get(joystickName)).get(index - joystickAxisCounts.get(joystickName))) {
                    case 1: {
                        return 0.25f;
                    }
                    case 8: {
                        return 0.5f;
                    }
                    case 4: {
                        return 0.75f;
                    }
                    case 2: {
                        return 1.0f;
                    }
                }
                return 1.0f;
            }
            return GLFW.glfwGetJoystickButtons((int)joystickMap.get(joystickName)).get(index - joystickAxisCounts.get(joystickName) - joystickHatCounts.get(joystickName)) == 1 ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean getJoystickButtonValue(String joystickName, int index) {
        if (joystickMap.containsKey(joystickName)) {
            return GLFW.glfwGetJoystickButtons((int)joystickMap.get(joystickName)).get(index - joystickAxisCounts.get(joystickName) - joystickHatCounts.get(joystickName)) == 1;
        }
        return false;
    }

    @Override
    public int getTrackedMouseWheel() {
        int returnValue = lastScrollValue;
        lastScrollValue = 0;
        return returnValue;
    }

    @Override
    public boolean isLeftMouseButtonDown() {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
    }

    @Override
    public boolean isRightMouseButtonDown() {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    @SubscribeEvent
    public static void onIVKeyInput(InputEvent.Key event) {
        if (configKey.m_90857_() && !InterfaceManager.clientInterface.isGUIOpen()) {
            new GUIConfig();
        } else if (((Boolean)ConfigSystem.settings.general.devMode.value).booleanValue() && importKey.m_90857_()) {
            EntityManager.doImports(() -> InterfaceManager.clientInterface.getClientPlayer().displayChatMessage(LanguageSystem.SYSTEM_DEBUG, JSONParser.importAllJSONs(true)));
        }
    }

    @SubscribeEvent
    public static void onIVMouseScroll(ScreenEvent.MouseScrolled.Post event) {
        if (InterfaceManager.clientInterface.isGUIOpen()) {
            lastScrollValue = (int)event.getScrollDelta();
        }
    }

    static {
        runningJoystickThread = false;
        joystickEnabled = false;
        joystickBlocked = false;
        joystickNameCounters = new HashMap<String, Integer>();
        joystickMap = new LinkedHashMap<String, Integer>();
        joystickAxisCounts = new LinkedHashMap<String, Integer>();
        joystickHatCounts = new LinkedHashMap<String, Integer>();
        joystickButtonCounts = new LinkedHashMap<String, Integer>();
        joystickComponentCounts = new LinkedHashMap<String, Integer>();
    }
}

