/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import mcinterface1201.BuilderBlock;
import mcinterface1201.BuilderTileEntity;
import mcinterface1201.BuilderTileEntityEnergyCharger;
import mcinterface1201.BuilderTileEntityFluidTank;
import mcinterface1201.BuilderTileEntityInventoryContainer;
import mcinterface1201.WrapperItemStack;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.blocks.components.ABlockBaseTileEntity;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityEnergyCharger;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityFluidTankProvider;
import minecrafttransportsimulator.blocks.tileentities.components.ITileEntityInventoryProvider;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BuilderBlockTileEntity
extends BuilderBlock
implements EntityBlock {
    public static IntegerProperty LIGHT = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);

    BuilderBlockTileEntity(ABlockBase block) {
        super(block, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(block.hardness, block.blastResistance).m_60955_().m_60953_(BuilderBlockTileEntity.getLightValue()));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0)));
    }

    public static ToIntFunction<BlockState> getLightValue() {
        return state -> (Integer)state.m_61143_((Property)LIGHT);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)LIGHT, (Comparable)Integer.valueOf(0));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LIGHT});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (ITileEntityFluidTankProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return new BuilderTileEntityFluidTank(pos, state);
        }
        if (ITileEntityInventoryProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return new BuilderTileEntityInventoryContainer(pos, state);
        }
        if (ITileEntityEnergyCharger.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return new BuilderTileEntityEnergyCharger(pos, state);
        }
        return new BuilderTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> blockEntityType) {
        if (ITileEntityFluidTankProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return BuilderBlockTileEntity.createTickerHelper(blockEntityType, (BlockEntityType)BuilderTileEntityFluidTank.TE_TYPE2.get(), BuilderBlockTileEntity::tick);
        }
        if (ITileEntityInventoryProvider.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return BuilderBlockTileEntity.createTickerHelper(blockEntityType, (BlockEntityType)BuilderTileEntityInventoryContainer.TE_TYPE2.get(), BuilderBlockTileEntity::tick);
        }
        if (ITileEntityEnergyCharger.class.isAssignableFrom(((ABlockBaseTileEntity)this.block).getTileEntityClass())) {
            return BuilderBlockTileEntity.createTickerHelper(blockEntityType, (BlockEntityType)BuilderTileEntityEnergyCharger.TE_TYPE2.get(), BuilderBlockTileEntity::tick);
        }
        return BuilderBlockTileEntity.createTickerHelper(blockEntityType, (BlockEntityType)BuilderTileEntity.TE_TYPE.get(), BuilderBlockTileEntity::tick);
    }

    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> pServerType, BlockEntityType<E> pClientType, BlockEntityTicker<? super E> pTicker) {
        return pClientType == pServerType ? pTicker : null;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BuilderTileEntity blockEntity) {
        blockEntity.tick();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
                return ((BuilderTileEntity)tile).tileEntity.interact(WrapperPlayer.getWrapperFor(player)) ? InteractionResult.CONSUME : InteractionResult.FAIL;
            }
        } else {
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        BlockEntity tile;
        if (!world.m_5776_() && (tile = world.m_7702_(pos)) instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            ((BuilderTileEntity)tile).tileEntity.onNeighborChanged(new Point3D(facingPos.m_123341_(), facingPos.m_123342_(), facingPos.m_123343_()));
        }
        return super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        IWrapperItemStack stack;
        ATileEntityBase<?> tile;
        BlockEntity mcTile = world.m_7702_(pos);
        if (mcTile instanceof BuilderTileEntity && (tile = ((BuilderTileEntity)mcTile).tileEntity) != null && (stack = tile.getStack()) != null) {
            return ((WrapperItemStack)stack).stack;
        }
        return super.m_7397_(world, pos, state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity tile = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (tile instanceof BuilderTileEntity && ((BuilderTileEntity)tile).tileEntity != null) {
            ArrayList<ItemStack> convertedDrops = new ArrayList<ItemStack>();
            convertedDrops.add(((WrapperItemStack)((BuilderTileEntity)tile).tileEntity.getStack()).stack);
            return convertedDrops;
        }
        return super.m_49635_(state, builder);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        this.block.onBroken(WrapperWorld.getWrapperFor(world), new Point3D(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        ATileEntityBase<?> tile;
        BlockEntity mcTile = world.m_7702_(pos);
        if (mcTile instanceof BuilderTileEntity && (tile = ((BuilderTileEntity)mcTile).tileEntity) != null) {
            return Shapes.m_83064_((AABB)WrapperWorld.convertWithOffset(tile.boundingBox, -pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_()));
        }
        return Shapes.m_83040_();
    }
}

