/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register.helpers.list_providers;

import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.lopyluna.dndecor.register.DnDecorStoneTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;

public class MaterialTypeProvider {
    public static Map<NonNullSupplier<Block>, String> stoneTypesRegister = new HashMap<NonNullSupplier<Block>, String>();
    public static List<NonNullSupplier<Block>> stoneTypes = new ArrayList<NonNullSupplier<Block>>();
    public static List<NonNullSupplier<MetalType>> metalTypes = new ArrayList<NonNullSupplier<MetalType>>();
    public static List<String> NA = new ArrayList<String>(List.of("NA"));

    public static void checkStoneTypeList() {
        for (DnDecorStoneTypes dnDecorStoneTypes : DnDecorStoneTypes.values()) {
            if (dnDecorStoneTypes == null || dnDecorStoneTypes.baseBlock == null || stoneTypes.contains(dnDecorStoneTypes.baseBlock)) continue;
            stoneTypesRegister.putIfAbsent(dnDecorStoneTypes.baseBlock, Lang.asId((String)dnDecorStoneTypes.name()).replace("_block", ""));
            stoneTypes.add(dnDecorStoneTypes.baseBlock);
        }
        for (DnDecorStoneTypes dnDecorStoneTypes : AllPaletteStoneTypes.values()) {
            if (dnDecorStoneTypes == null || ((AllPaletteStoneTypes)dnDecorStoneTypes).baseBlock == null || stoneTypes.contains(((AllPaletteStoneTypes)dnDecorStoneTypes).baseBlock)) continue;
            stoneTypesRegister.putIfAbsent((NonNullSupplier<Block>)((AllPaletteStoneTypes)dnDecorStoneTypes).baseBlock, Lang.asId((String)dnDecorStoneTypes.name()).replace("_block", ""));
            stoneTypes.add((NonNullSupplier<Block>)((AllPaletteStoneTypes)dnDecorStoneTypes).baseBlock);
        }
    }

    public static Item getResolvedItem(ResourceLocation loc) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(loc);
        if (item == Items.f_41852_) {
            System.out.println("\u26a0 Item not yet registered: " + String.valueOf(loc) + " is " + String.valueOf(item));
        }
        return item;
    }

    public static class MetalType {
        public final String id;
        public final String type;
        public final SoundType sound;
        public final MapColor color;
        public final TagKey<Item> tag;
        public final List<Object> itemEntries = new ArrayList<Object>();
        public final List<String> modIDs;

        public MetalType(String type, SoundType sound, MapColor color, TagKey<Item> tag, List<String> modIDs) {
            this(type, sound, color, null, tag, modIDs);
        }

        public MetalType(String type, SoundType sound, MapColor color, NonNullSupplier<ItemLike> item, TagKey<Item> tag) {
            this(type, sound, color, item != null ? List.of(item) : List.of(), tag, new ArrayList<String>());
        }

        public MetalType(String type, SoundType sound, MapColor color, ItemProviderEntry<?> item, TagKey<Item> tag) {
            this(type, sound, color, item != null ? List.of(item) : List.of(), tag, new ArrayList<String>());
        }

        public MetalType(String type, SoundType sound, MapColor color, NonNullSupplier<ItemLike> item) {
            this(type, sound, color, item != null ? List.of(item) : List.of(), null, new ArrayList<String>());
        }

        public MetalType(String type, SoundType sound, MapColor color, ItemProviderEntry<?> item) {
            this(type, sound, color, item != null ? List.of(item) : List.of(), null, new ArrayList<String>());
        }

        public MetalType(String type, SoundType sound, MapColor color, List<Object> itemEntries, TagKey<Item> tag, List<String> modIDs) {
            this.id = type.toLowerCase().replace(" ", "_");
            this.type = type;
            this.sound = sound;
            this.color = color;
            this.tag = tag;
            this.modIDs = modIDs;
            if (itemEntries != null) {
                this.itemEntries.addAll(itemEntries);
            }
            if (!this.modIDs.contains("NA")) {
                metalTypes.add((NonNullSupplier<MetalType>)((NonNullSupplier)() -> this));
            }
        }

        public boolean requireMods() {
            return !this.modIDs.isEmpty();
        }

        public MetalType entries(Object ... entries) {
            this.itemEntries.addAll(List.of(entries));
            return this;
        }

        public DataIngredient getIngredient() {
            if (this.tag != null) {
                return DataIngredient.tag(this.tag);
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (Object entry : this.itemEntries) {
                ItemStack stack;
                ItemLike itemLike = this.resolveItemLike(entry);
                if (itemLike == null || itemLike.m_5456_() == Items.f_41852_ || (stack = itemLike.m_5456_().m_7968_()).m_41619_()) continue;
                stacks.add(stack);
            }
            if (!stacks.isEmpty()) {
                return DataIngredient.ingredient((Ingredient)Ingredient.m_43921_(stacks.stream()), (ItemLike)((ItemStack)stacks.get(0)).m_41720_());
            }
            return null;
        }

        private ItemLike resolveItemLike(Object entry) {
            if (entry instanceof ItemProviderEntry) {
                ItemProviderEntry provider = (ItemProviderEntry)entry;
                return (ItemLike)provider.get();
            }
            if (entry instanceof Supplier) {
                ItemLike il;
                Supplier supplier = (Supplier)entry;
                Object t = supplier.get();
                return t instanceof ItemLike ? (il = (ItemLike)t) : null;
            }
            return null;
        }
    }
}

