/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register;

import dev.lopyluna.dndecor.DnDecor;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class DnDecorTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return DnDecorTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public static <T> TagKey<T> modTag(Registry<T> registry, String path) {
        return DnDecorTags.optionalTag(registry, DnDecor.asResource(path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return DnDecorTags.commonTag(BuiltInRegistries.f_256975_, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return DnDecorTags.commonTag(BuiltInRegistries.f_257033_, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return DnDecorTags.commonTag(BuiltInRegistries.f_257020_, path);
    }

    public static TagKey<Block> modBlockTag(String path) {
        return DnDecorTags.modTag(BuiltInRegistries.f_256975_, path);
    }

    public static TagKey<Item> modItemTag(String path) {
        return DnDecorTags.modTag(BuiltInRegistries.f_257033_, path);
    }

    public static TagKey<Fluid> modFluidTag(String path) {
        return DnDecorTags.modTag(BuiltInRegistries.f_257020_, path);
    }

    public static void init() {
        BlockTags.init();
        ItemTags.init();
    }

    public static enum BlockTags {
        DYED_BLOCKS;

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private BlockTags() {
            this(NameSpace.MOD);
        }

        private BlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private BlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? DnDecorTags.optionalTag(BuiltInRegistries.f_256975_, id) : net.minecraft.tags.BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean is(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean is(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.is((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean is(ItemLike item) {
            BlockItem blockItem;
            return item instanceof BlockItem && this.is((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean is(BlockState state) {
            return state.m_204336_(this.tag);
        }

        public boolean is(TagKey<Block> tag) {
            return tag == this.tag;
        }

        private static void init() {
        }
    }

    public static enum ItemTags {
        DYED_BLOCKS,
        PALETTE_BLOCKS;

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private ItemTags() {
            this(NameSpace.MOD);
        }

        private ItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private ItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private ItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private ItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? DnDecorTags.optionalTag(BuiltInRegistries.f_257033_, id) : net.minecraft.tags.ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("dndecor", false, true),
        COMMON("forge"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

