/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.register;

import com.simibubi.create.api.stress.BlockStressValues;
import dev.lopyluna.dndecor.content.configs.DClient;
import dev.lopyluna.dndecor.content.configs.DCommon;
import dev.lopyluna.dndecor.content.configs.DServer;
import dev.lopyluna.dndecor.content.configs.server.kinetics.DStress;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.config.ConfigBase;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DnDecorConfigs {
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static DClient client;
    private static DCommon common;
    private static DServer server;

    public static DClient client() {
        return client;
    }

    public static DCommon common() {
        return common;
    }

    public static DServer server() {
        return server;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(ModLoadingContext context, ModContainer container) {
        client = DnDecorConfigs.register(DClient::new, ModConfig.Type.CLIENT);
        common = DnDecorConfigs.register(DCommon::new, ModConfig.Type.COMMON);
        server = DnDecorConfigs.register(DServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        DStress stress = DnDecorConfigs.server().kinetics.stressValues;
        BlockStressValues.IMPACTS.registerProvider(stress::getImpact);
        BlockStressValues.CAPACITIES.registerProvider(stress::getCapacity);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }
}

