/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.datagen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.lopyluna.dndecor.DnDecor;
import dev.lopyluna.dndecor.register.DnDecorTags;
import dev.lopyluna.dndecor.register.helpers.MetalTypeHelper;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class DatagenTags {
    public static void addGenerators() {
        DnDecor.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, DatagenTags::genBlockTags);
        DnDecor.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, DatagenTags::genItemTags);
    }

    private static void genBlockTags(RegistrateTagsProvider<Block> provIn) {
        TagGen.CreateTagsProvider prov = new TagGen.CreateTagsProvider(provIn, Block::m_204297_);
        TagGen.CreateTagAppender mineablePickaxe = prov.tag(BlockTags.f_144282_);
        TagGen.CreateTagAppender mineableAxe = prov.tag(BlockTags.f_144280_);
        for (Map<String, TagKey<Block>> tag : MetalTypeHelper.mineableBlocksTag) {
            TagKey<Block> axe;
            TagKey<Block> pickaxe = tag.get("pickaxe");
            if (pickaxe != null) {
                mineablePickaxe.addOptionalTag(pickaxe);
            }
            if ((axe = tag.get("axe")) == null) continue;
            mineableAxe.addOptionalTag(axe);
        }
        for (DnDecorTags.BlockTags tag : DnDecorTags.BlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genItemTags(RegistrateTagsProvider<Item> provIn) {
        TagGen.CreateTagsProvider prov = new TagGen.CreateTagsProvider(provIn, Item::m_204114_);
        prov.tag(DnDecorTags.commonItemTag("assets/create/crushing_wheels")).add((Object)AllBlocks.CRUSHING_WHEEL.m_5456_());
        prov.tag(DnDecorTags.commonItemTag("assets/create/millstones")).add((Object)AllBlocks.MILLSTONE.m_5456_());
        prov.tag(DnDecorTags.commonItemTag("assets/create/flywheels")).add((Object)AllBlocks.FLYWHEEL.m_5456_());
        prov.tag(DnDecorTags.commonItemTag("assets/create/display_boards")).add((Object)AllBlocks.DISPLAY_BOARD.m_5456_());
        for (DnDecorTags.ItemTags tag : DnDecorTags.ItemTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }
}

