/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.storage_container;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlock;
import dev.lopyluna.dndecor.content.blocks.storage_container.ColoredStorageContainerBlockEntity;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import java.util.Objects;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredStorageContainerItem
extends BlockItem {
    private final DyeColor color;

    public ColoredStorageContainerItem(Item.Properties properties, DyeColor color) {
        super(null, properties);
        this.color = color;
    }

    @Nullable
    protected BlockState m_5965_(@NotNull BlockPlaceContext pContext) {
        if (super.m_5965_(pContext) == null) {
            return super.m_5965_(pContext);
        }
        return (BlockState)Objects.requireNonNull(super.m_5965_(pContext)).m_61124_(ColoredStorageContainerBlock.COLOR, (Comparable)this.color);
    }

    @NotNull
    public InteractionResult m_40576_(@NotNull BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(BlockPos p_195943_1_, Level p_195943_2_, Player p_195943_3_, ItemStack p_195943_4_, BlockState p_195943_5_) {
        MinecraftServer minecraftserver = p_195943_2_.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = p_195943_4_.m_41737_("BlockEntityTag");
        if (nbt != null) {
            nbt.m_128473_("Length");
            nbt.m_128473_("Size");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
        }
        return super.m_7274_(p_195943_1_, p_195943_2_, p_195943_3_, p_195943_4_, p_195943_5_);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockPos placedOnPos = pos.m_121945_(face.m_122424_());
        BlockState placedOnState = world.m_8055_(placedOnPos);
        ColoredStorageContainerBlockEntity tankAt = (ColoredStorageContainerBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)DnDecorBETypes.COLORED_STORAGE_CONTAINER.get()), (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        ColoredStorageContainerBlockEntity controllerBE = tankAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        if (!ColoredStorageContainerBlock.isVault(placedOnState)) {
            return;
        }
        int width = controllerBE.radius;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        Direction.Axis vaultBlockAxis = ColoredStorageContainerBlock.getVaultBlockAxis(placedOnState);
        if (vaultBlockAxis == null) {
            return;
        }
        if (face.m_122434_() != vaultBlockAxis) {
            return;
        }
        Direction vaultFacing = Direction.m_122387_((Direction.Axis)vaultBlockAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == vaultFacing.m_122424_() ? controllerBE.m_58899_().m_121945_(vaultFacing.m_122424_()) : controllerBE.m_58899_().m_5484_(vaultFacing, controllerBE.length);
        if (VecHelper.getCoordinate((Vec3i)startPos, (Direction.Axis)vaultBlockAxis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)vaultBlockAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.m_7918_(0, xOffset, zOffset) : startPos.m_7918_(xOffset, zOffset, 0);
                blockState = world.m_8055_(offsetPos);
                if (ColoredStorageContainerBlock.isVault(blockState)) continue;
                if (!blockState.m_247087_()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = vaultBlockAxis == Direction.Axis.X ? startPos.m_7918_(0, xOffset, zOffset) : startPos.m_7918_(xOffset, zOffset, 0);
                blockState = world.m_8055_(offsetPos);
                if (ColoredStorageContainerBlock.isVault(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceVaultSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceVaultSound");
            }
        }
    }
}

