/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks.bolt;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.lopyluna.dndecor.content.blocks.bolt.BoltRotation;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class BoltBlock
extends Block
implements IWrenchable {
    public static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape SHAPE_UP = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)3.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final EnumProperty<BoltRotation> ROT = EnumProperty.m_61587_((String)"rotation", BoltRotation.class);

    public BoltBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_(ROT, (Comparable)((Object)BoltRotation.D0)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(dir.m_122424_()), (Direction)dir);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ROT});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction face = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockState base = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)face);
        if (!base.m_60710_((LevelReader)level, pos)) {
            return null;
        }
        BoltRotation rot = BoltRotation.D180;
        if (player != null && face.m_122434_().m_122478_()) {
            double yaw = player.m_146908_();
            if (face == Direction.UP) {
                yaw = -(yaw + 180.0);
            }
            rot = BoltRotation.fromYaw(yaw);
        }
        return (BlockState)base.m_61124_(ROT, (Comparable)((Object)rot));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState rotated = (BlockState)state.m_61124_(ROT, (Comparable)((Object)((BoltRotation)((Object)state.m_61143_(ROT))).getNext()));
        if (!rotated.m_60710_((LevelReader)level, context.m_8083_())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.m_8055_(pos) != state) {
            this.playRotateSound(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState rotated = (BlockState)state.m_61124_(ROT, (Comparable)((Object)((BoltRotation)((Object)state.m_61143_(ROT))).getPrev()));
        if (!rotated.m_60710_((LevelReader)level, context.m_8083_())) {
            return InteractionResult.PASS;
        }
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        if (level.m_8055_(pos) != state) {
            this.playRotateSound(level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void playRotateSound(Level level, BlockPos pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, level.f_46441_.m_188501_() + 0.5f);
    }
}

