/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor.content.blocks;

import com.simibubi.create.foundation.utility.BlockHelper;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class VelvetBlock
extends Block {
    protected final DyeColor color;

    public VelvetBlock(BlockBehaviour.Properties pProperties, DyeColor color) {
        super(pProperties);
        this.color = color;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            if (!level.f_46443_) {
                level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.1f - level.f_46441_.m_188501_() * 0.2f);
            }
            this.applyDye(state, level, pos, hitResult.m_82450_(), hitResult.m_82434_(), color);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void applyDye(BlockState state, Level world, BlockPos pos, Vec3 hit, Direction direction, @Nullable DyeColor color) {
        BlockState newState = (color == null ? DnDecorBlocks.DYED_VELVET_BLOCKS.get(DyeColor.WHITE) : DnDecorBlocks.DYED_VELVET_BLOCKS.get(color)).getDefaultState();
        if (state != (newState = BlockHelper.copyProperties((BlockState)state, (BlockState)newState))) {
            world.m_46597_(pos, newState);
            return;
        }
        List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)hit, (Direction.Axis)direction.m_122434_());
        for (Direction d : directions) {
            BlockPos offset = pos.m_121945_(d);
            BlockState adjacentState = world.m_8055_(offset);
            Block block = adjacentState.m_60734_();
            if (!(block instanceof VelvetBlock) || state == adjacentState) continue;
            world.m_46597_(offset, newState);
            return;
        }
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        frontier.add(pos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int timeout = 100;
        while (!frontier.isEmpty() && timeout-- >= 0) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            visited.add(currentPos);
            for (Direction d : Iterate.directions) {
                BlockState adjacentState;
                Block block;
                BlockPos offset;
                if (d.m_122434_() == direction.m_122434_() || visited.contains(offset = currentPos.m_121945_(d)) || !((block = (adjacentState = world.m_8055_(offset)).m_60734_()) instanceof VelvetBlock)) continue;
                if (state != adjacentState) {
                    world.m_46597_(offset, newState);
                }
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance * 0.1f);
    }
}

