/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndecor;

import com.mojang.logging.LogUtils;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.entry.RegistryEntry;
import dev.lopyluna.dndecor.DnDecorClient;
import dev.lopyluna.dndecor.DnDecorDatagen;
import dev.lopyluna.dndecor.register.AllMetalTypes;
import dev.lopyluna.dndecor.register.DnDecorBETypes;
import dev.lopyluna.dndecor.register.DnDecorBlocks;
import dev.lopyluna.dndecor.register.DnDecorCreativeTabs;
import dev.lopyluna.dndecor.register.DnDecorItems;
import dev.lopyluna.dndecor.register.DnDecorLangPartial;
import dev.lopyluna.dndecor.register.DnDecorStoneTypes;
import dev.lopyluna.dndecor.register.DnDecorTags;
import java.util.ArrayList;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Mod(value="dndecor")
public class DnDecor {
    public static final String NAME = "Design n' Decor";
    public static final String MOD_ID = "dndecor";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean LOAD_ALL_METALS = false;
    public static final CreateRegistrate REGISTRATE = ((CreateRegistrate)CreateRegistrate.create((String)"dndecor").defaultCreativeTab((ResourceKey)null)).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public DnDecor() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        REGISTRATE.registerEventListeners(modEventBus);
        AllMetalTypes.register();
        DnDecorStoneTypes.register(REGISTRATE);
        DnDecorLangPartial.init();
        DnDecorTags.init();
        DnDecorItems.register();
        DnDecorBlocks.register();
        DnDecorBETypes.register();
        DnDecorCreativeTabs.register(modEventBus);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> DnDecorClient::new);
        modEventBus.addListener(this::addCreative);
        modEventBus.addListener(EventPriority.LOWEST, DnDecorDatagen::gatherData);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)DnDecorCreativeTabs.BASE_CREATIVE_TAB.getKey())) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (RegistryEntry entry : REGISTRATE.getAll(Registries.f_256913_)) {
                ItemStack stack;
                Item item = (Item)entry.get();
                if (item instanceof BlockItem || item instanceof BucketItem || (stack = item.m_7968_()).m_41619_()) continue;
                if (stack.m_204117_(DnDecorTags.ItemTags.PALETTE_BLOCKS.tag)) {
                    stacks.add(stack);
                    continue;
                }
                event.m_246342_(stack);
            }
            for (RegistryEntry entry : REGISTRATE.getAll(Registries.f_256747_)) {
                Block block = (Block)entry.get();
                Item item = block.m_5456_();
                ItemStack stack = item.m_7968_();
                if (stack.m_41619_()) continue;
                if (stack.m_204117_(DnDecorTags.ItemTags.PALETTE_BLOCKS.tag)) {
                    stacks.add(stack);
                    continue;
                }
                event.m_246342_(stack);
            }
            for (ItemStack stack : stacks) {
                event.m_246342_(stack);
            }
        }
    }

    public static LangBuilder lang() {
        return new LangBuilder(MOD_ID);
    }

    public static ResourceLocation asResource(String loc) {
        return new ResourceLocation(MOD_ID, loc);
    }

    public static ResourceLocation emptyLoc() {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"empty");
    }

    @Nullable
    public static KineticStats create(Item item) {
        BlockItem blockItem;
        Block block;
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof IRotate) {
            return new KineticStats(block);
        }
        return null;
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)DnDecor.create(item))));
    }
}

