/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class BlockRecipeIngredient
implements Predicate<BlockState> {
    public static final BlockRecipeIngredient NONE = new BlockRecipeIngredient(){
        private List<ItemStack> ingredient;

        @Override
        public List<ItemStack> getBlockItems() {
            if (this.ingredient == null) {
                this.ingredient = new ArrayList<ItemStack>(1);
                this.ingredient.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)"Invalid block")));
            }
            return this.ingredient;
        }

        @Override
        public boolean test(BlockState blockState) {
            return false;
        }

        @Override
        public String stringForSerialization() {
            return "/";
        }
    };

    public static BlockRecipeIngredient of(Block block) {
        return new BlockIngredient(block);
    }

    public static BlockRecipeIngredient of(TagKey<Block> tag) {
        return new TagIngredient(tag);
    }

    public static BlockRecipeIngredient fromJson(JsonElement el) {
        return el.isJsonPrimitive() && el.getAsJsonPrimitive().isString() ? BlockRecipeIngredient.fromString(el.getAsJsonPrimitive().getAsString()) : NONE;
    }

    public static BlockRecipeIngredient fromNetwork(FriendlyByteBuf buf) {
        return BlockRecipeIngredient.fromString(buf.m_130277_());
    }

    public static BlockRecipeIngredient fromString(String s) {
        return s.charAt(0) == '/' ? NONE : (s.charAt(0) == '#' ? BlockRecipeIngredient.of((TagKey<Block>)TagKey.m_203882_(CBCRegistryUtils.getBlockRegistryKey(), (ResourceLocation)CBCUtils.location(s.substring(1)))) : CBCRegistryUtils.getOptionalBlock(CBCUtils.location(s)).map(BlockRecipeIngredient::of).orElse(NONE));
    }

    public abstract List<ItemStack> getBlockItems();

    public void toNetwork(FriendlyByteBuf buf) {
        buf.m_130070_(this.stringForSerialization());
    }

    public abstract String stringForSerialization();

    public static class BlockIngredient
    extends BlockRecipeIngredient {
        private final Block block;
        private final List<ItemStack> blocks = new ArrayList<ItemStack>(1);

        protected BlockIngredient(Block block) {
            this.block = block;
            this.blocks.add(new ItemStack((ItemLike)this.block));
        }

        @Override
        public boolean test(BlockState blockState) {
            return blockState.m_60713_(this.block);
        }

        @Override
        public List<ItemStack> getBlockItems() {
            return this.blocks;
        }

        @Override
        public String stringForSerialization() {
            return CBCRegistryUtils.getBlockLocation(this.block).toString();
        }
    }

    public static class TagIngredient
    extends BlockRecipeIngredient {
        private final TagKey<Block> tag;
        private List<ItemStack> blocks = null;

        protected TagIngredient(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public boolean test(BlockState blockState) {
            return blockState.m_204336_(this.tag);
        }

        @Override
        public List<ItemStack> getBlockItems() {
            if (this.blocks == null) {
                this.blocks = new ArrayList<ItemStack>();
                for (Holder<Block> holder : CBCRegistryUtils.getBlockTagEntries(this.tag)) {
                    this.blocks.add(new ItemStack((ItemLike)holder.m_203334_()));
                }
                if (this.blocks.isEmpty()) {
                    this.blocks.add(new ItemStack((ItemLike)Blocks.f_50375_).m_41714_((Component)Component.m_237113_((String)("Empty Tag: " + String.valueOf(this.tag.f_203868_())))));
                }
            }
            return this.blocks;
        }

        @Override
        public String stringForSerialization() {
            return "#" + String.valueOf(this.tag.f_203868_());
        }
    }
}

