/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.trainmap;

import com.simibubi.create.compat.trainmap.TrainMapSync;
import com.simibubi.create.compat.trainmap.TrainMapSyncClient;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.createmod.catnip.data.Pair;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class TrainMapSyncPacket
extends SimplePacketBase {
    public List<Pair<UUID, TrainMapSync.TrainMapSyncEntry>> entries = new ArrayList<Pair<UUID, TrainMapSync.TrainMapSyncEntry>>();
    public boolean light;

    public TrainMapSyncPacket(boolean light) {
        this.light = light;
    }

    public void add(UUID trainId, TrainMapSync.TrainMapSyncEntry data) {
        this.entries.add((Pair<UUID, TrainMapSync.TrainMapSyncEntry>)Pair.of((Object)trainId, (Object)data));
    }

    public TrainMapSyncPacket(FriendlyByteBuf buffer) {
        DimensionPalette dimensionPalette = DimensionPalette.receive(buffer);
        this.light = buffer.readBoolean();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            UUID id = buffer.m_130259_();
            TrainMapSync.TrainMapSyncEntry entry = new TrainMapSync.TrainMapSyncEntry();
            entry.receive(buffer, dimensionPalette, this.light);
            this.entries.add((Pair<UUID, TrainMapSync.TrainMapSyncEntry>)Pair.of((Object)id, (Object)entry));
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        DimensionPalette dimensionPalette = new DimensionPalette();
        for (Pair<UUID, TrainMapSync.TrainMapSyncEntry> pair : this.entries) {
            ((TrainMapSync.TrainMapSyncEntry)pair.getSecond()).gatherDimensions(dimensionPalette);
        }
        dimensionPalette.send(buffer);
        buffer.writeBoolean(this.light);
        buffer.m_130130_(this.entries.size());
        for (Pair<UUID, TrainMapSync.TrainMapSyncEntry> pair : this.entries) {
            buffer.m_130077_((UUID)pair.getFirst());
            ((TrainMapSync.TrainMapSyncEntry)pair.getSecond()).send(buffer, dimensionPalette, this.light);
        }
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> TrainMapSyncClient.receive(this));
        return true;
    }
}

